/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.utils;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import open.dolphin.log.LogWriter;

public class ReflectMonitor
implements ActionListener {
    public static final String STATE_PROP = "resultProp";
    public static final int DONE = 0;
    public static final int TIME_OVER = 1;
    public static final int CANCELED = 2;
    public static final int DEFAULT_DELAY = 200;
    public static final int DEFAULT_MAX = 30000;
    public static final String DEFAULT_NOTE = "\u691c\u7d22\u3057\u3066\u3044\u307e\u3059...  ";
    public static final int DEFAULT_DECIDE = 200;
    public static final int DEFAULT_MILLIS = 600;
    private Object target;
    private String method;
    private Class[] argClasses;
    private Object[] args;
    private Object result;
    private Component cmp;
    private Object message;
    private String note = "\u691c\u7d22\u3057\u3066\u3044\u307e\u3059...  ";
    private int decideToPopup = 200;
    private int millisToPopup = 600;
    private int delay = 200;
    private int maxEstimation = 30000;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);
    private int state = -1;
    private boolean cancelOk = true;
    private boolean timeoutOk = true;
    private Thread exec;
    private boolean done;
    private int min;
    private int max;
    private int current;
    private ProgressMonitor progress;
    private Timer timer;

    public ReflectMonitor() {
    }

    public ReflectMonitor(Object target, String method, Class[] argClasses, Object[] args) {
        this();
        this.setReflection(target, method, argClasses, args);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(STATE_PROP, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(STATE_PROP, l);
    }

    public Object getResult() {
        return this.result;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int result) {
        int old = this.state;
        this.state = result;
        this.boundSupport.firePropertyChange(STATE_PROP, old, this.state);
    }

    public void setReflection(Object target, String method, Class[] argClasses, Object[] args) {
        this.target = target;
        this.method = method;
        this.argClasses = argClasses;
        this.args = args;
    }

    public void setMonitor(Component cmp, Object message, String note, int delay, int maxEstimation) {
        this.cmp = cmp;
        this.message = message;
        this.note = note;
        this.setDelay(delay);
        this.setMaxEstimation(maxEstimation);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getMaxEstimation() {
        return this.maxEstimation;
    }

    public void setMaxEstimation(int maxEstimation) {
        this.maxEstimation = maxEstimation;
    }

    public int getDecideToPopup() {
        return this.decideToPopup;
    }

    public void setDecideToPopup(int decideToPopup) {
        this.decideToPopup = decideToPopup;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
    }

    public boolean isCancelOk() {
        return this.cancelOk;
    }

    public void setCancelOk(boolean ok) {
        this.cancelOk = ok;
    }

    public boolean isTimeoutOk() {
        return this.timeoutOk;
    }

    public void setTimeoutOk(boolean timeout) {
        this.timeoutOk = timeout;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public void start() {
        if (this.target == null || this.method == null) {
            throw new RuntimeException("Reflection \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u53c8\u306f\u30e1\u30bd\u30c3\u30c9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.min = 0;
        this.max = this.getMaxEstimation() / this.getDelay();
        this.progress = new ProgressMonitor(this.cmp, this.message, this.note, this.min, this.max);
        this.progress.setMillisToDecideToPopup(this.getDecideToPopup());
        this.progress.setMillisToPopup(this.getMillisToPopup());
        this.timer = new Timer(this.getDelay(), this);
        try {
            Method mth = this.target.getClass().getMethod(this.method, this.argClasses);
            this.result = mth.invoke(this.target, this.args);
        }
        catch (Exception ex) {
            LogWriter.error(this.getClass(), ex);
        }
        this.setDone(true);
        this.timer.start();
    }

    private void stop() {
        if (this.progress != null) {
            this.progress.close();
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    private void interrupt() {
        if (this.exec != null) {
            this.exec.interrupt();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ++this.current;
        if (this.progress.isCanceled()) {
            if (this.isCancelOk()) {
                this.interrupt();
                this.stop();
                this.setState(2);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (this.isDone()) {
            this.stop();
            this.setState(0);
        } else if (this.current > this.max && this.isTimeoutOk()) {
            this.interrupt();
            this.stop();
            this.setState(1);
        } else {
            this.progress.setProgress(this.current);
        }
    }
}

