/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.Attribute;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.Dictionary;
import fr.apteryx.imageio.dicom.Tag;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public final class DataElement
implements Serializable {
    public final int tag;
    private transient Attribute attribute;
    public final Object value;

    public DataElement(int n, Object object) {
        this.tag = n;
        this.value = object;
    }

    DataElement(int n, Object object, Attribute attribute) {
        this(n, object);
        this.attribute = attribute;
    }

    DataElement(int n, int n2) {
        this(n, new Integer(n2));
    }

    final synchronized Attribute getAttribute() {
        if (this.attribute == null) {
            this.attribute = Dictionary.getAttribute(this.tag);
        }
        return this.attribute;
    }

    String toString(String string) {
        Serializable serializable;
        String string2;
        if (this.value == null) {
            string2 = "<null> ";
        } else if (this.value.getClass().isArray()) {
            serializable = new StringBuffer();
            for (int i = 0; i < Array.getLength(this.value); ++i) {
                if (i > 0) {
                    ((StringBuffer)serializable).append(", ");
                }
                if (i > 100) {
                    ((StringBuffer)serializable).append("...");
                    break;
                }
                Object object = Array.get(this.value, i);
                ((StringBuffer)serializable).append(object == null ? "<null>" : object.toString());
            }
            string2 = new String((StringBuffer)serializable);
        } else if (this.value instanceof Collection) {
            serializable = new StringBuffer("[\n");
            Iterator iterator = ((Collection)this.value).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof DataSet) {
                    ((StringBuffer)serializable).append(((DataSet)e).toString(string + " "));
                    if (!iterator.hasNext()) continue;
                    ((StringBuffer)serializable).append(string);
                    ((StringBuffer)serializable).append(" ---\n");
                    continue;
                }
                ((StringBuffer)serializable).append(string);
                ((StringBuffer)serializable).append(e == null ? "<null>" : e.toString());
                ((StringBuffer)serializable).append("\n");
            }
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append(']');
            string2 = new String((StringBuffer)serializable);
        } else {
            string2 = this.value.toString();
        }
        serializable = this.getAttribute();
        if (serializable != null && ((Attribute)serializable).name != null) {
            return ((Attribute)serializable).name + " = " + string2;
        }
        return Tag.toString(this.tag) + " = " + string2;
    }

    public String getVR() {
        if (this.attribute == null) {
            this.attribute = Dictionary.getAttribute(this.tag);
        }
        return this.attribute == null ? null : this.attribute.VR;
    }

    public String toString() {
        return this.toString("");
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DataElement)) {
            return false;
        }
        DataElement dataElement = (DataElement)object;
        if (dataElement.tag != this.tag) {
            return false;
        }
        if (this.value == null) {
            return dataElement.value == null;
        }
        return this.value.equals(dataElement.value);
    }
}

