/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.CounterImageOutputStream;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomMetadata;
import fr.apteryx.imageio.dicom.DicomObject;
import fr.apteryx.imageio.dicom.DicomReader;
import fr.apteryx.imageio.dicom.Plugin;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.TransferSyntax;
import fr.apteryx.imageio.dicom.UID;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;

public class FileSet {
    private final DataSet ds;
    private final Directory root;
    private boolean enforceFileIDRestrictions = true;

    public FileSet(File file, DicomReader dicomReader) throws IOException {
        DicomObject dicomObject = new DicomObject(new FileImageInputStream(file), dicomReader == null ? null : dicomReader.wl, RawValues.NONE);
        if (!dicomObject.sopClass.equals("1.2.840.10008.1.3.10")) {
            throw new DicomException("ProtocoleViolation", "Object in file " + file + " is not a directory");
        }
        this.ds = dicomObject.ds;
        Collection collection = (Collection)this.ds.findValue(266784, Collection.class);
        if (collection == null) {
            this.root = new Directory();
        } else {
            Object object;
            HashMap<Long, Record> hashMap = new HashMap<Long, Record>();
            Iterator<Object> iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (DataSet)iterator.next();
                hashMap.put(new Long(((DataSet)object).offset), new Record((DataSet)object));
            }
            iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                object = (Record)iterator.next();
                ((Record)object).link(hashMap);
            }
            this.root = new Directory(this.ds.findLong(266752), hashMap);
        }
    }

    public FileSet(String string) {
        this.ds = new DataSet();
        if (string != null) {
            this.ds.add(266544, string);
        }
        this.ds.add(266752, 0);
        this.ds.add(266754, 0);
        this.ds.add(266770, 0);
        this.root = new Directory();
    }

    public FileSet(String string, File file, String string2) throws UnsupportedEncodingException {
        this(string);
        this.ds.add(266561, file);
        if (string2 != null) {
            this.ds.add(266562, Plugin.userToDicomCharacterSet(string2));
        }
    }

    public void add(File file, DicomReader dicomReader) throws IOException {
        FileImageInputStream fileImageInputStream = new FileImageInputStream(file);
        dicomReader.setInput(fileImageInputStream);
        DicomMetadata dicomMetadata = dicomReader.getDicomMetadata();
        this.add(file, dicomMetadata, null);
        fileImageInputStream.close();
        dicomReader.setInput(null);
    }

    public void add(File file, DicomMetadata dicomMetadata, String string) throws DicomException {
        String string2 = dicomMetadata.getSOPClass();
        if (string == null) {
            string = dicomMetadata.obj.readTS.uid;
        }
        if ("1.2.840.10008.3.1.2.1.1".equals(string2)) {
            Record record = this.getPatientRecord(dicomMetadata);
            record.setFile(file, dicomMetadata, string);
        } else if ("1.2.840.10008.3.1.2.3.1".equals(string2)) {
            Record record = this.getStudyRecord(dicomMetadata);
            record.setFile(file, dicomMetadata, string);
        } else {
            Record record = this.getSeriesRecord(dicomMetadata);
            Record record2 = new Record("IMAGE");
            record2.copy(2097171, dicomMetadata);
            record2.setFile(file, dicomMetadata, string);
            record.addInLowerLevelDirectory(record2);
        }
    }

    public void setEnforceFileIDRestrictions(boolean bl) {
        this.enforceFileIDRestrictions = bl;
    }

    public void write(File file) throws IOException {
        ArrayList arrayList = new ArrayList();
        this.root.traverse(arrayList, file.getCanonicalFile());
        this.ds.add(266784, arrayList);
        DicomObject dicomObject = new DicomObject(this.ds, "1.2.840.10008.1.3.10", UID.createUID(1), null);
        dicomObject.write(new CounterImageOutputStream(), TransferSyntax.EXPLICIT_LITTLEENDIAN, null);
        this.root.traverse2();
        if (this.root.records.size() > 0) {
            this.ds.add(266752, ((Record)((Directory)this.root).records.get((int)0)).ds.offset - 8L);
            this.ds.add(266754, ((Record)((Directory)this.root).records.get((int)(((Directory)this.root).records.size() - 1))).ds.offset - 8L);
        }
        File file2 = new File(file, "DICOMDIR");
        file2.delete();
        FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file2);
        dicomObject.write(fileImageOutputStream, TransferSyntax.EXPLICIT_LITTLEENDIAN, null);
        fileImageOutputStream.close();
    }

    private Record getPatientRecord(DicomMetadata dicomMetadata) {
        Record record = this.root.findRecord(0x100020, dicomMetadata);
        if (record == null) {
            record = new Record("PATIENT");
            record.copy(0x100020, dicomMetadata);
            record.copy(0x100010, dicomMetadata);
            this.root.addRecord(record);
        }
        return record;
    }

    private Record getStudyRecord(DicomMetadata dicomMetadata) throws DicomException {
        Directory directory = this.getPatientRecord(dicomMetadata).getInitLowerLevelDirectory();
        Record record = directory.findRecord(0x20000D, dicomMetadata);
        if (record == null) {
            record = new Record("STUDY");
            record.copy(524320, dicomMetadata);
            record.copy(524336, dicomMetadata);
            record.copy(0x20000D, dicomMetadata);
            record.copy(0x200010, dicomMetadata);
            record.copy(528432, dicomMetadata);
            record.copy(524368, dicomMetadata);
            directory.addRecord(record);
        }
        return record;
    }

    private Record getSeriesRecord(DicomMetadata dicomMetadata) throws DicomException {
        Directory directory = this.getStudyRecord(dicomMetadata).getInitLowerLevelDirectory();
        Record record = directory.findRecord(0x20000E, dicomMetadata);
        if (record == null) {
            record = new Record("SERIES");
            record.copy(524384, dicomMetadata);
            record.copy(0x20000E, dicomMetadata);
            record.copy(0x200011, dicomMetadata);
            directory.addRecord(record);
        }
        return record;
    }

    private static File objectToFile(Object object) {
        if (object instanceof String) {
            return new File((String)object);
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            if (stringArray.length < 1) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(File.separator);
                stringBuffer.append(stringArray[i]);
            }
            return new File(stringBuffer.toString());
        }
        return null;
    }

    public String getID() {
        return this.ds.findString(266544);
    }

    public File getDescriptorFile() {
        return FileSet.objectToFile(this.ds.findValue(266561));
    }

    public Directory getRootDirectory() {
        return this.root;
    }

    private static Record getRecordByOff(long l, HashMap hashMap) throws DicomException {
        Record record = (Record)hashMap.get(new Long(l));
        if (record == null) {
            throw new DicomException("ProtocoleViolation", "Invalid offset in dicom directory");
        }
        return record;
    }

    public String toString() {
        File file;
        StringBuffer stringBuffer = new StringBuffer("Dicom File Set\n");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append("ID:" + string + "\n");
        }
        if ((file = this.getDescriptorFile()) != null) {
            stringBuffer.append("Descriptor file:" + file + "\n");
        }
        stringBuffer.append("Root directory:\n" + this.root);
        return stringBuffer.toString();
    }

    public class Record {
        final DataSet ds;
        private Directory lowerlevelDir;
        private File file;

        Record(DataSet dataSet) {
            this.ds = dataSet;
            Object object = dataSet.findValue(267520);
            if (object != null) {
                this.file = FileSet.objectToFile(object);
            }
        }

        Record(String string) {
            this.ds = new DataSet();
            this.ds.add(267264, 0);
            this.ds.add(267280, 65535);
            this.ds.add(267296, 0);
            this.ds.add(267312, string);
            this.ds.checkSpecificCharacterSet();
        }

        void addInLowerLevelDirectory(Record record) {
            if (this.lowerlevelDir == null) {
                this.lowerlevelDir = new Directory();
            }
            this.lowerlevelDir.addRecord(record);
        }

        void setFile(File file, DicomMetadata dicomMetadata, String string) {
            this.file = file;
            this.ds.add(267536, dicomMetadata.getSOPClass());
            this.ds.add(267537, dicomMetadata.getSOPInstance());
            this.ds.add(267538, string);
            String string2 = dicomMetadata.getAttributeString(524314);
            if (string2 != null) {
                this.ds.add(267546, string2);
            }
        }

        void setFileId(File file) throws IOException {
            char c;
            int n;
            String[] stringArray;
            block7: {
                if (this.file == null) {
                    return;
                }
                stringArray = new String[8];
                File file2 = this.file.getCanonicalFile();
                n = 0;
                do {
                    stringArray[n] = file2.getName();
                    if (FileSet.this.enforceFileIDRestrictions) {
                        if (stringArray[n].length() > 8) {
                            throw new DicomException("ApplicationError", "path component " + stringArray[n] + " is too long");
                        }
                        for (int i = stringArray[n].length() - 1; i >= 0; --i) {
                            c = stringArray[n].charAt(i);
                            if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
                            throw new DicomException("ApplicationError", "character " + c + " is invalid in a path component");
                        }
                    }
                    ++n;
                    if ((file2 = file2.getParentFile()) == null) {
                        throw new DicomException("ApplicationError", "File " + this.file + " is not below " + file);
                    }
                    if (file2.equals(file)) break block7;
                } while (!FileSet.this.enforceFileIDRestrictions || n <= 8);
                throw new DicomException("ApplicationError", "File " + this.file + " has more than 8 components below " + file);
            }
            String[] stringArray2 = new String[n];
            for (c = n - 1; c >= '\u0000'; --c) {
                stringArray2[n - 1 - c] = stringArray[c];
            }
            this.ds.add(267520, stringArray2);
        }

        public String getType() {
            return this.ds.findString(267312);
        }

        void link(HashMap hashMap) throws DicomException {
            long l;
            long l2 = this.ds.findLong(267296);
            if (l2 != 0L) {
                this.lowerlevelDir = new Directory(l2, hashMap);
            }
            if (this.file == null && (l = this.ds.findLong(267524)) != 0L) {
                this.file = FileSet.getRecordByOff((long)l, (HashMap)hashMap).file;
            }
        }

        void copy(int n, DicomMetadata dicomMetadata) {
            this.ds.add(n, dicomMetadata.getAttribute(n));
        }

        public Directory getLowerLevelDirectory() throws DicomException {
            return this.lowerlevelDir;
        }

        Directory getInitLowerLevelDirectory() throws DicomException {
            if (this.lowerlevelDir == null) {
                this.lowerlevelDir = new Directory();
            }
            return this.lowerlevelDir;
        }

        public File getFile() throws DicomException {
            return this.file;
        }

        public String getSOPInstance() {
            return this.ds.findString(267537);
        }

        public String getSOPClass() {
            return this.ds.findString(267536);
        }

        public String getTransferSyntax() {
            return this.ds.findString(267538);
        }

        public Object getAttribute(int n) {
            return this.ds.findValue(n);
        }

        public DataSet getAttributes() {
            return this.ds;
        }

        public String toString() {
            return this.toString("");
        }

        private String toString(String string) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer("Record type:");
            stringBuffer.append(this.getType());
            try {
                object = this.getFile();
                if (object != null) {
                    stringBuffer.append(", file:");
                    stringBuffer.append(object);
                }
            }
            catch (DicomException dicomException) {
                stringBuffer.append(", file: error");
            }
            stringBuffer.append("\n");
            try {
                object = this.getLowerLevelDirectory();
                if (object != null && ((Directory)object).getNumRecords() > 0) {
                    stringBuffer.append(((Directory)object).toString(string + ' '));
                }
            }
            catch (DicomException dicomException) {
                stringBuffer.append("Lower level: error\n");
            }
            return stringBuffer.toString();
        }
    }

    public class Directory {
        private final ArrayList records = new ArrayList();

        Directory(long l, HashMap hashMap) throws DicomException {
            while (l > 0L) {
                Record record = FileSet.getRecordByOff(l, hashMap);
                if (record.ds.findInt(267280) != 0) {
                    this.records.add(record);
                }
                l = record.ds.findLong(267264);
            }
        }

        Directory() {
        }

        void traverse(ArrayList arrayList, File file) throws IOException {
            Iterator iterator = this.records.iterator();
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                arrayList.add(record.ds);
                record.setFileId(file);
                Directory directory = record.lowerlevelDir;
                if (directory == null) continue;
                directory.traverse(arrayList, file);
            }
        }

        void traverse2() {
            Record record;
            if (this.records.size() == 0) {
                return;
            }
            Record record2 = (Record)this.records.get(0);
            for (int i = 1; i < this.records.size(); ++i) {
                record = (Record)this.records.get(i);
                record2.ds.add(267264, record.ds.offset - 8L);
                record2 = record;
            }
            Iterator iterator = this.records.iterator();
            while (iterator.hasNext()) {
                record = (Record)iterator.next();
                Directory directory = record.lowerlevelDir;
                if (directory == null || directory.records.size() == 0) continue;
                record.ds.add(267296, ((Record)directory.records.get((int)0)).ds.offset - 8L);
                directory.traverse2();
            }
        }

        public Record getRecord(int n) {
            return (Record)this.records.get(n);
        }

        public int getNumRecords() {
            return this.records.size();
        }

        public String toString() {
            return this.toString("");
        }

        Record findRecord(int n, DicomMetadata dicomMetadata) {
            for (int i = this.records.size() - 1; i >= 0; --i) {
                Record record = (Record)this.records.get(i);
                String string = record.ds.findString(n);
                if (string == null || !string.equals(dicomMetadata.getAttributeString(n))) continue;
                return record;
            }
            return null;
        }

        void addRecord(Record record) {
            this.records.add(record);
        }

        private String toString(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.records.size(); ++i) {
                stringBuffer.append(string);
                stringBuffer.append(((Record)this.records.get(i)).toString(string));
            }
            return new String(stringBuffer);
        }
    }
}

