/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.AbstractSyntax;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.TransferSyntax;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

abstract class PDU {
    static final byte ASSOCIATE_RQ = 1;
    static final byte ASSOCIATE_AC = 2;
    static final byte ASSOCIATE_RJ = 3;
    static final byte DATA_TF = 4;
    static final byte RELEASE_RQ = 5;
    static final byte RELEASE_RP = 6;
    static final byte ABORT = 7;
    final byte type;

    static final int readUnsignedShort(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    static final long readUnsignedInt(byte[] byArray, int n) {
        return (((long)byArray[n] & 0xFFL) << 24) + (((long)byArray[n + 1] & 0xFFL) << 16) + (((long)byArray[n + 2] & 0xFFL) << 8) + ((long)byArray[n + 3] & 0xFFL);
    }

    static final PDU create(byte by, byte[] byArray, int n) throws DicomException {
        switch (by) {
            case 1: 
            case 2: {
                return new AssociateRqAc(by, byArray, n);
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return new AssociateRjReleaseRqReleaseRpAbort(by, byArray, n);
            }
            case 4: {
                return new DataTf(byArray, n);
            }
        }
        return null;
    }

    PDU(byte by) {
        this.type = by;
    }

    abstract void send(OutputStream var1) throws IOException;

    static class DataTf
    extends PDU {
        final byte[] buf;
        final int len;

        DataTf(byte[] byArray, int n) {
            super((byte)4);
            this.buf = byArray;
            this.len = n;
        }

        void send(OutputStream outputStream) {
            throw new Error("NOT USED");
        }
    }

    static class AssociateRjReleaseRqReleaseRpAbort
    extends PDU {
        final byte result;
        final byte source;
        final byte reason;
        private static byte[] head = new byte[]{0, 0, 0, 0, 4, 0};

        AssociateRjReleaseRqReleaseRpAbort(byte by, int n, int n2, int n3) {
            super(by);
            this.result = (byte)n;
            this.source = (byte)n2;
            this.reason = (byte)n3;
        }

        AssociateRjReleaseRqReleaseRpAbort(byte by, byte[] byArray, int n) throws DicomException {
            super(by);
            if (n != 4) {
                throw new DicomException("ProtocoleViolation", "PDU length is incorrect");
            }
            this.result = byArray[1];
            this.source = byArray[2];
            this.reason = byArray[3];
        }

        void send(OutputStream outputStream) throws IOException {
            outputStream.write(this.type);
            outputStream.write(head);
            outputStream.write(this.result);
            outputStream.write(this.source);
            outputStream.write(this.reason);
        }
    }

    static class AssociateRqAc
    extends PDU {
        final AbstractSyntax[] syntaxes;
        final long maxLength;
        final String calledAE;
        final String callingAE;

        AssociateRqAc(byte by, String string, String string2, AbstractSyntax[] abstractSyntaxArray, long l) {
            super(by);
            this.calledAE = string;
            this.callingAE = string2;
            this.syntaxes = abstractSyntaxArray;
            this.maxLength = l;
        }

        AssociateRqAc(byte by, byte[] byArray, int n) throws DicomException {
            super(by);
            int n2;
            int n3 = AssociateRqAc.readUnsignedShort(byArray, 0);
            if ((n3 & 1) != 1) {
                throw new DicomException("Unsupported", "Dicom protocol version");
            }
            this.calledAE = new String(byArray, 4, 16).trim();
            this.callingAE = new String(byArray, 20, 16).trim();
            int n4 = 68;
            long l = 0L;
            ArrayList<AbstractSyntax> arrayList = new ArrayList<AbstractSyntax>();
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            block9: while (n4 < n) {
                n2 = byArray[n4] & 0xFF;
                switch (n2) {
                    case 16: {
                        int n5 = AssociateRqAc.readUnsignedShort(byArray, n4 + 2);
                        String string = new String(byArray, n4 + 4, n5);
                        if (!string.equals("1.2.840.10008.3.1.1.1")) {
                            throw new DicomException("ProtocoleViolation", "Application context item value in A-ASSOCIATE-RQ/AC PDU is not Dicom Application Context");
                        }
                        n4 += 4 + n5;
                        continue block9;
                    }
                    case 32: 
                    case 33: {
                        int n6;
                        int n5 = AssociateRqAc.readUnsignedShort(byArray, n4 + 2);
                        int n7 = byArray[n4 + 4] & 0xFF;
                        if (n7 < 1 || (n7 & 1) != 1) {
                            throw new DicomException("ProtocoleViolation", "Presentation context ID in A-ASSOCIATE-RQ/AC PDU is not odd and positive (" + n7 + ")");
                        }
                        int n8 = byArray[n4 + 6] & 0xFF;
                        n5 -= 4;
                        n4 += 8;
                        String string = null;
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        while (n5 > 0) {
                            int n9 = byArray[n4] & 0xFF;
                            n6 = AssociateRqAc.readUnsignedShort(byArray, n4 + 2);
                            String string2 = new String(byArray, n4 + 4, n6);
                            n5 -= 4 + n6;
                            n4 += 4 + n6;
                            switch (n9) {
                                case 48: {
                                    string = string2;
                                    break;
                                }
                                case 64: {
                                    if (n2 != 32 && n8 != 0) break;
                                    arrayList2.add(string2);
                                }
                            }
                        }
                        AbstractSyntax abstractSyntax = new AbstractSyntax(n7, string, arrayList2);
                        abstractSyntax.reason = n8 < 0 || n8 >= AbstractSyntax.REASONS.length ? 2 : n8;
                        arrayList.add(abstractSyntax);
                        continue block9;
                    }
                    case 80: {
                        int n6;
                        int n5 = AssociateRqAc.readUnsignedShort(byArray, n4 + 2);
                        n4 += 4;
                        while (n5 > 0) {
                            n6 = byArray[n4] & 0xFF;
                            int n10 = AssociateRqAc.readUnsignedShort(byArray, n4 + 2);
                            n5 -= 4 + n10;
                            if (n6 == 81 && n10 == 4) {
                                l = AssociateRqAc.readUnsignedInt(byArray, n4 + 4);
                            } else if (n6 == 84) {
                                int n11 = AssociateRqAc.readUnsignedShort(byArray, n4 + 4);
                                String string = new String(byArray, n4 + 6, n11);
                                byte by2 = byArray[n4 + 6 + n11];
                                byte by3 = byArray[n4 + 7 + n11];
                                int n12 = by2 == 1 && by3 == 1 ? 3 : (by2 == 1 ? 1 : (by3 == 1 ? 2 : 0));
                                hashMap.put(string, new Integer(n12));
                            }
                            n4 += 4 + n10;
                        }
                        continue block9;
                    }
                }
                throw new DicomException("ProtocoleViolation", "Unknown item " + n2 + " in A-ASSOCIATE-RQ/AC PDU");
            }
            this.syntaxes = new AbstractSyntax[arrayList.size()];
            arrayList.toArray(this.syntaxes);
            if (hashMap.size() > 0) {
                for (n2 = 0; n2 < this.syntaxes.length; ++n2) {
                    Integer n13 = (Integer)hashMap.get(this.syntaxes[n2].name);
                    if (n13 == null) continue;
                    this.syntaxes[n2].role = n13;
                }
            }
            this.maxLength = l;
        }

        void send(OutputStream outputStream) throws IOException {
            Item item;
            Item item2 = new Item(this.type, true);
            item2.addShort(1);
            item2.addShort(0);
            item2.addAE(this.calledAE);
            item2.addAE(this.callingAE);
            for (int i = 0; i < 32; ++i) {
                item2.addByte(0);
            }
            Item item3 = new Item(16);
            item3.add("1.2.840.10008.3.1.1.1");
            item2.add(item3);
            for (int i = 0; i < this.syntaxes.length; ++i) {
                Item item4;
                item = new Item(this.type == 1 ? 32 : 33);
                item.addByte(this.syntaxes[i].id);
                item.addByte(0);
                item.addByte(this.type == 1 || this.syntaxes[i].selected_ts != null ? 0 : this.syntaxes[i].reason);
                item.addByte(0);
                if (this.type == 1) {
                    item4 = new Item(48);
                    item4.add(this.syntaxes[i].name);
                    item.add(item4);
                    for (int j = 0; j < this.syntaxes[i].ts.size(); ++j) {
                        Item item5 = new Item(64);
                        item5.add((String)this.syntaxes[i].ts.get(j));
                        item.add(item5);
                    }
                } else {
                    item4 = new Item(64);
                    TransferSyntax transferSyntax = this.syntaxes[i].selected_ts;
                    item4.add(transferSyntax == null ? "" : transferSyntax.uid);
                    item.add(item4);
                }
                item2.add(item);
            }
            Item item6 = new Item(80);
            item = new Item(81);
            item.addInt((int)this.maxLength);
            item6.add(item);
            item = new Item(82);
            item.add("1.2.826.0.1.3680043.2.228.0.2");
            item6.add(item);
            for (int i = 0; i < this.syntaxes.length; ++i) {
                if (this.syntaxes[i].role == 0 || this.type != 1 && this.syntaxes[i].selected_ts == null) continue;
                item = new Item(84);
                item.addShort(this.syntaxes[i].name.length());
                item.add(this.syntaxes[i].name);
                item.addByte(this.syntaxes[i].role == 2 ? 0 : 1);
                item.addByte(this.syntaxes[i].role == 1 ? 0 : 1);
                item6.add(item);
            }
            item = new Item(85);
            item.add("1.10");
            item6.add(item);
            item2.add(item6);
            item2.writeTo(outputStream);
        }
    }

    static final class Item
    extends ByteArrayOutputStream {
        private boolean large;

        Item(int n) {
            this(n, false);
        }

        void addByte(int n) {
            this.write(n);
        }

        void addShort(int n) {
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        }

        void addInt(int n) {
            this.write(n >> 24 & 0xFF);
            this.write(n >> 16 & 0xFF);
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        }

        void add(String string) {
            for (int i = 0; i < string.length(); ++i) {
                this.write(string.charAt(i));
            }
        }

        void addAE(String string) {
            if (string.length() <= 16) {
                int n;
                for (n = 0; n < string.length(); ++n) {
                    this.write(string.charAt(n));
                }
                for (n = string.length(); n < 16; ++n) {
                    this.write(32);
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    this.write(string.charAt(i));
                }
            }
        }

        void add(Item item) {
            try {
                item.writeTo(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        Item(int n, boolean bl) {
            super(32);
            this.large = bl;
            this.write(n);
            this.write(0);
            if (bl) {
                this.addInt(0);
            } else {
                this.addShort(0);
            }
        }

        private void seal() {
            if (this.large) {
                int n = this.count - 6;
                this.buf[2] = (byte)(n >> 24);
                this.buf[3] = (byte)(n >> 16);
                this.buf[4] = (byte)(n >> 8);
                this.buf[5] = (byte)n;
            } else {
                this.buf[2] = (byte)(this.count - 4 >> 8);
                this.buf[3] = (byte)(this.count - 4);
            }
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            this.seal();
            super.writeTo(outputStream);
        }
    }
}

