/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.Association;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.Identifier;
import fr.apteryx.imageio.dicom.QuerySCPListener;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.ReceivedMessage;
import fr.apteryx.imageio.dicom.SCP;
import fr.apteryx.imageio.dicom.SecureTransport;
import fr.apteryx.imageio.dicom.Server;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.InetAddress;

abstract class QuerySCP
extends SCP {
    private static ReferenceQueue queue = new ReferenceQueue();
    final QuerySCPListener listener;

    QuerySCP(QuerySCPListener querySCPListener, int n, InetAddress inetAddress, SecureTransport secureTransport) throws DicomException {
        super(Server.getInstance(n, inetAddress, secureTransport));
        this.listener = querySCPListener;
    }

    public void start() throws IOException {
        this.server.registerSCP(this);
    }

    public void stop() throws IOException {
        this.server.deregisterSCP(this);
    }

    Object isFindOrCancel(Association association, ReceivedMessage receivedMessage) throws IOException {
        DataSet dataSet = receivedMessage.command;
        int n = dataSet.findInt(256);
        switch (n) {
            case 32: {
                String string = dataSet.findString(2);
                if (!this.listener.supportsSyntax(string)) {
                    return null;
                }
                int n2 = 0;
                if (string != null) {
                    for (int i = 0; i < Identifier.FIND_UID.length; ++i) {
                        if (!string.equals(Identifier.FIND_UID[i])) continue;
                        n2 = i;
                        break;
                    }
                }
                Identifier identifier = new Identifier(n2, receivedMessage.readDataSet(RawValues.NONE, true, null));
                int n3 = dataSet.findInt(272);
                return new FindRq(identifier, n3);
            }
            case 4095: {
                Operation operation;
                int n4 = dataSet.findInt(288);
                OperationRef operationRef = (OperationRef)association.rcv_messages.get(new Integer(n4));
                if (operationRef != null && (operation = (Operation)operationRef.get()) != null) {
                    operation.cancel();
                }
                return Boolean.TRUE;
            }
        }
        return null;
    }

    class FindRq {
        Identifier id;
        int mid;

        FindRq(Identifier identifier, int n) {
            this.id = identifier;
            this.mid = n;
        }
    }

    class Operation {
        private boolean canceled = false;
        final Association association;
        public final Identifier identifier;
        final int messageId;
        int model;

        private void cancel() {
            this.canceled = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        Operation(Association association, Identifier identifier, int n) {
            OperationRef operationRef;
            this.association = association;
            this.identifier = identifier;
            this.messageId = n;
            this.model = identifier.getModel();
            association.rcv_messages.put(new Integer(n), new OperationRef(this));
            while ((operationRef = (OperationRef)queue.poll()) != null) {
                association.rcv_messages.remove(new Integer(operationRef.mid));
            }
        }

        public void sendQueryResponsePending(Identifier identifier) throws IOException {
            this.sendQueryResponse(65280, identifier.ds);
        }

        public void sendQueryResponseFinal() throws IOException {
            this.sendQueryResponse(0, null);
        }

        public void sendQueryResponse(int n, DataSet dataSet) throws IOException {
            DataSet dataSet2 = new DataSet();
            dataSet2.add(2, Identifier.FIND_UID[this.model]);
            dataSet2.add(256, 32800);
            dataSet2.add(288, this.messageId);
            dataSet2.add(2048, dataSet == null ? 257 : 258);
            dataSet2.add(2304, n);
            dataSet2.add(0, dataSet2.getLength());
            if (dataSet != null) {
                dataSet.checkSpecificCharacterSet();
            }
            this.association.sendMessage(Identifier.FIND_UID[this.model], dataSet2, dataSet, false, null);
        }
    }

    static class OperationRef
    extends WeakReference {
        final int mid;

        OperationRef(Operation operation) {
            super(operation, queue);
            this.mid = operation.messageId;
        }
    }
}

