/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SecureTransport {
    public static final int CLIENTAUTH_NONE = 0;
    public static final int CLIENTAUTH_REQUEST = 1;
    public static final int CLIENTAUTH_NEED = 2;
    private static SSLContext sslContext;
    private static final String TLS_RSA_WITH_3DES_EDE_CBC_SHA = "TLS_RSA_WITH_3DES_EDE_CBC_SHA";
    private static final String TLS_RSA_WITH_AES_128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA";
    private static final String[] TLS;
    public static SecureTransport BASIC_TLS_PROFILE_AUTH_ACCEPTOR_REQUESTOR;
    public static SecureTransport BASIC_TLS_PROFILE_AUTH_ACCEPTOR;
    public static SecureTransport BASIC_TLS_PROFILE_AUTH_REQUESTOR;
    public static SecureTransport AES_TLS_PROFILE_AUTH_ACCEPTOR_REQUESTOR;
    public static SecureTransport AES_TLS_PROFILE_AUTH_ACCEPTOR;
    public static SecureTransport AES_TLS_PROFILE_AUTH_REQUESTOR;
    public static SecureTransport JAVA_DEFAULT_AUTH_ACCEPTOR_REQUESTOR;
    public static SecureTransport JAVA_DEFAULT_AUTH_ACCEPTOR;
    public static SecureTransport JAVA_DEFAULT_AUTH_REQUESTOR;
    private final String[] ciphers;
    private final String[] protocols;
    private final boolean clientIsRequestor;
    private final int clientAuth;

    private static SSLServerSocketFactory getServerSocketFactory() {
        return sslContext == null ? (SSLServerSocketFactory)SSLServerSocketFactory.getDefault() : sslContext.getServerSocketFactory();
    }

    private static SSLSocketFactory getSocketFactory() {
        return sslContext == null ? (SSLSocketFactory)SSLSocketFactory.getDefault() : sslContext.getSocketFactory();
    }

    public static SSLContext getSSLContext() {
        return sslContext;
    }

    public static void setSSLContext(SSLContext sSLContext) {
        sslContext = sSLContext;
    }

    public SecureTransport(String[] stringArray, String[] stringArray2, boolean bl, int n) {
        this.protocols = stringArray == null ? null : (String[])stringArray.clone();
        this.ciphers = stringArray2 == null ? null : (String[])stringArray2.clone();
        this.clientIsRequestor = bl;
        this.clientAuth = n;
    }

    public String[] getCipherSuites() {
        return this.ciphers == null ? null : (String[])this.ciphers.clone();
    }

    public String[] getProtocols() {
        return this.protocols == null ? null : (String[])this.protocols.clone();
    }

    public boolean getClientIsRequestor() {
        return this.clientIsRequestor;
    }

    public int getClientAuth() {
        return this.clientAuth;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SecureTransport)) {
            return false;
        }
        SecureTransport secureTransport = (SecureTransport)object;
        return Arrays.equals(secureTransport.ciphers, this.ciphers) && Arrays.equals(secureTransport.protocols, this.protocols) && secureTransport.clientAuth == this.clientAuth && secureTransport.clientIsRequestor == this.clientIsRequestor;
    }

    SSLSocket createSocket(InetAddress inetAddress, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)SecureTransport.getSocketFactory().createSocket(inetAddress, n);
        if (this.ciphers != null) {
            sSLSocket.setEnabledCipherSuites(this.ciphers);
        }
        if (this.protocols != null) {
            sSLSocket.setEnabledCipherSuites(this.protocols);
        }
        sSLSocket.setUseClientMode(this.clientIsRequestor);
        if (!this.clientIsRequestor) {
            switch (this.clientAuth) {
                case 0: {
                    sSLSocket.setNeedClientAuth(false);
                    sSLSocket.setWantClientAuth(false);
                    break;
                }
                case 1: {
                    sSLSocket.setWantClientAuth(true);
                    break;
                }
                case 2: {
                    sSLSocket.setNeedClientAuth(true);
                }
            }
        }
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    SSLServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SSLServerSocketFactory sSLServerSocketFactory = SecureTransport.getServerSocketFactory();
        SSLServerSocket sSLServerSocket = (SSLServerSocket)(inetAddress == null ? sSLServerSocketFactory.createServerSocket(n, n2) : sSLServerSocketFactory.createServerSocket(n, n2, inetAddress));
        if (this.ciphers != null) {
            sSLServerSocket.setEnabledCipherSuites(this.ciphers);
        }
        if (this.protocols != null) {
            sSLServerSocket.setEnabledProtocols(this.protocols);
        }
        sSLServerSocket.setUseClientMode(!this.clientIsRequestor);
        if (this.clientIsRequestor) {
            switch (this.clientAuth) {
                case 0: {
                    sSLServerSocket.setNeedClientAuth(false);
                    sSLServerSocket.setWantClientAuth(false);
                    break;
                }
                case 1: {
                    sSLServerSocket.setWantClientAuth(true);
                    break;
                }
                case 2: {
                    sSLServerSocket.setNeedClientAuth(true);
                }
            }
        }
        return sSLServerSocket;
    }

    static {
        TLS = new String[]{"TLSv1"};
        BASIC_TLS_PROFILE_AUTH_ACCEPTOR_REQUESTOR = new SecureTransport(TLS, new String[]{TLS_RSA_WITH_3DES_EDE_CBC_SHA}, true, 2);
        BASIC_TLS_PROFILE_AUTH_ACCEPTOR = new SecureTransport(TLS, new String[]{TLS_RSA_WITH_3DES_EDE_CBC_SHA}, true, 0);
        BASIC_TLS_PROFILE_AUTH_REQUESTOR = new SecureTransport(TLS, new String[]{TLS_RSA_WITH_3DES_EDE_CBC_SHA}, true, 0);
        AES_TLS_PROFILE_AUTH_ACCEPTOR_REQUESTOR = new SecureTransport(TLS, new String[]{TLS_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_3DES_EDE_CBC_SHA}, true, 2);
        AES_TLS_PROFILE_AUTH_ACCEPTOR = new SecureTransport(TLS, new String[]{TLS_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_3DES_EDE_CBC_SHA}, true, 0);
        AES_TLS_PROFILE_AUTH_REQUESTOR = new SecureTransport(TLS, new String[]{TLS_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_3DES_EDE_CBC_SHA}, false, 0);
        JAVA_DEFAULT_AUTH_ACCEPTOR_REQUESTOR = new SecureTransport(null, null, true, 2);
        JAVA_DEFAULT_AUTH_ACCEPTOR = new SecureTransport(null, null, true, 0);
        JAVA_DEFAULT_AUTH_REQUESTOR = new SecureTransport(null, null, false, 0);
    }
}

