/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.AERegistry;
import fr.apteryx.imageio.dicom.Association;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.ExceptionListener;
import fr.apteryx.imageio.dicom.Plugin;
import fr.apteryx.imageio.dicom.RawValues;
import fr.apteryx.imageio.dicom.ReceivedMessage;
import fr.apteryx.imageio.dicom.SCP;
import fr.apteryx.imageio.dicom.SecureTransport;
import fr.apteryx.imageio.dicom.StorageSCP;
import fr.apteryx.imageio.dicom.VerificationSCP;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Server {
    public static final ExceptionListener DEFAULT_EXCEPTION_LISTENER = new ExceptionListener(){

        public void exceptionOccured(Exception exception) {
            System.err.print("SERVER ERROR: ");
            exception.printStackTrace();
        }
    };
    private static final HashMap servers = new HashMap();
    private ServerSocket ss;
    private final HashSet providers = new HashSet();
    private final HashMap serviced_types = new HashMap();
    private ExceptionListener el = DEFAULT_EXCEPTION_LISTENER;
    private Thread th;
    RawValues rv = RawValues.NONE;
    private final int port;
    private final InetAddress addr;
    private final SecureTransport st;
    private final AERegistry aeRegistry = new AERegistry();

    static synchronized Server getInstance(int n, InetAddress inetAddress, SecureTransport secureTransport) throws DicomException {
        Integer n2 = new Integer(n);
        Server server = null;
        HashMap<Integer, Server> hashMap = (HashMap<Integer, Server>)servers.get(inetAddress);
        if (hashMap != null) {
            server = (Server)hashMap.get(n2);
        }
        if (server != null) {
            if (secureTransport == null) {
                if (server.st == null) {
                    return server;
                }
                throw new DicomException("ApplicationError", "An SCP using secure transport is already running on this port");
            }
            if (secureTransport.equals(server.st)) {
                return server;
            }
            throw new DicomException("ApplicationError", "An SCP using insecure transport or a differenct secure transport is already running on this port");
        }
        server = new Server(n, inetAddress, secureTransport);
        if (hashMap == null) {
            hashMap = new HashMap<Integer, Server>();
            servers.put(inetAddress, hashMap);
        }
        hashMap.put(n2, server);
        return server;
    }

    private Server(int n, InetAddress inetAddress, SecureTransport secureTransport) {
        this.port = n;
        this.addr = inetAddress;
        this.st = secureTransport;
        try {
            this.aeRegistry.registerAE(Plugin.getApplicationTitle(), inetAddress == null ? InetAddress.getLocalHost() : inetAddress, n, secureTransport);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        new VerificationSCP(this);
    }

    public AERegistry getAERegistry() {
        return this.aeRegistry;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.el = exceptionListener;
    }

    public void setRawValues(boolean bl) {
        this.setRawMode(bl);
    }

    public synchronized void setRawMode(boolean bl) {
        if (this.th != null) {
            throw new IllegalStateException("Server already started");
        }
        this.rv = bl ? RawValues.ALL : RawValues.NONE;
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            SCP sCP = (SCP)iterator.next();
            if (!(sCP instanceof StorageSCP)) continue;
            ((StorageSCP)sCP).setRawValues(this.rv);
        }
    }

    synchronized void registerSCP(SCP sCP) throws IOException {
        int[] nArray = sCP.getServicedMessageTypes();
        this.providers.add(sCP);
        for (int i = 0; i < nArray.length; ++i) {
            Integer n = new Integer(nArray[i]);
            SCP[] sCPArray = (SCP[])this.serviced_types.get(n);
            if (sCPArray == null) {
                this.serviced_types.put(n, new SCP[]{sCP});
                continue;
            }
            SCP[] sCPArray2 = new SCP[sCPArray.length + 1];
            for (int j = 0; j < sCPArray.length; ++j) {
                sCPArray2[j] = sCPArray[j];
            }
            sCPArray2[sCPArray.length] = sCP;
            this.serviced_types.put(n, sCPArray2);
        }
        if (this.providers.size() > 1) {
            this.start();
        }
    }

    synchronized int acceptsAE(String string, String string2) {
        int n = 7;
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            SCP sCP = (SCP)iterator.next();
            if (sCP instanceof VerificationSCP || !this.aeListed(string2, sCP.calledAE)) continue;
            n = 3;
            if (!this.aeListed(string, sCP.callingAE)) continue;
            return 0;
        }
        return n;
    }

    synchronized void deregisterSCP(SCP sCP) throws IOException {
        this.providers.remove(sCP);
        int[] nArray = sCP.getServicedMessageTypes();
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2;
            Integer n3 = new Integer(nArray[i]);
            SCP[] sCPArray = (SCP[])this.serviced_types.get(n3);
            if (sCPArray == null) continue;
            if (sCPArray.length == 1 && sCPArray[0] == sCP) {
                this.serviced_types.remove(n3);
                continue;
            }
            for (n2 = 0; n2 < sCPArray.length && sCPArray[n2] != sCP; ++n2) {
            }
            if (n2 >= sCPArray.length) continue;
            SCP[] sCPArray2 = new SCP[sCPArray.length - 1];
            for (n = 0; n < n2; ++n) {
                sCPArray2[n] = sCPArray[n];
            }
            for (n = n2 + 1; n < sCPArray.length; ++n) {
                sCPArray2[n - 1] = sCPArray[n];
            }
            this.serviced_types.put(n3, sCPArray2);
        }
        if (this.providers.size() <= 1) {
            this.stop();
        }
    }

    synchronized SCP getSCPSupportingAsSCU(String string) {
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            SCP sCP = (SCP)iterator.next();
            if (!sCP.supportsSyntaxAsSCU(string)) continue;
            return sCP;
        }
        return null;
    }

    synchronized SCP getSCPSupportingAsSCP(String string) {
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            SCP sCP = (SCP)iterator.next();
            if (!sCP.supportsSyntaxAsSCP(string)) continue;
            return sCP;
        }
        return null;
    }

    private synchronized void start() throws IOException {
        if (this.th == null) {
            this.ss = this.st == null ? (this.addr == null ? new ServerSocket(this.port, 50) : new ServerSocket(this.port, 50, this.addr)) : this.st.createServerSocket(this.port, 50, this.addr);
            this.th = new ServerThread();
            this.th.start();
        }
    }

    private synchronized void stop() throws IOException {
        if (this.th != null) {
            this.ss.close();
            try {
                this.th.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.th = null;
            this.ss = null;
        }
    }

    private void exceptionOccured(Exception exception) {
        if (this.el != null) {
            this.el.exceptionOccured(exception);
        }
    }

    void exceptionOccured(Association association, Exception exception) {
        association.abort();
        this.exceptionOccured(exception);
    }

    private boolean aeListed(String string, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void messageReceived(Association association, ReceivedMessage receivedMessage) throws IOException {
        SCP[] sCPArray;
        if (receivedMessage == null) {
            association.release();
            return;
        }
        Object object = receivedMessage.command.findValue(256);
        Server server = this;
        synchronized (server) {
            sCPArray = (SCP[])this.serviced_types.get(object);
        }
        if (sCPArray != null) {
            for (int i = 0; i < sCPArray.length; ++i) {
                SCP sCP = sCPArray[i];
                if (!this.aeListed(association.calledAE, sCP.calledAE) || !this.aeListed(association.callingAE, sCP.callingAE) || !sCP.messageReceived(association, receivedMessage)) continue;
                return;
            }
        }
        this.exceptionOccured(new DicomException("ProtocoleViolation", "Server on port " + this.port + " received a command of type " + object + " that no SCP can handle"));
        association.abort();
    }

    private final void debug(String string) {
        System.err.println(new Date() + " Server: " + string);
    }

    private class ServerThread
    extends Thread {
        ServerThread() {
            super("Server");
            this.setDaemon(Plugin.serversAreDaemons());
        }

        public void run() {
            block10: while (true) {
                try {
                    while (true) {
                        Socket socket;
                        try {
                            socket = Server.this.ss.accept();
                        }
                        catch (SocketException socketException) {
                            return;
                        }
                        try {
                            new Association(socket, Server.this);
                            continue block10;
                        }
                        catch (IOException iOException) {
                            Server.this.exceptionOccured(iOException);
                            try {
                                socket.close();
                                continue block10;
                            }
                            catch (IOException iOException2) {
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    try {
                        Server.this.ss.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                    return;
                }
            }
        }
    }
}

