/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.DicomException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

final class TransferSyntax
implements Serializable {
    static final TransferSyntax RLE_COMPRESSION;
    static final TransferSyntax EXPLICIT_BIGENDIAN;
    static final TransferSyntax EXPLICIT_LITTLEENDIAN;
    static final TransferSyntax IMPLICIT_LITTLEENDIAN;
    static final TransferSyntax JPEG_EXTENDED_2_4;
    static final TransferSyntax JPEG_BASELINE_1;
    static final TransferSyntax JPEG_PROGRESSIVE_10_12;
    static final TransferSyntax JPEG_LOSSLESS_14;
    static final TransferSyntax JPEG_LOSSLESS_15;
    static final TransferSyntax JPEG_LOSSLESS_14SV1;
    static final TransferSyntax JPEG_LS_LOSSLESS;
    static final TransferSyntax JPEG_LS_NEAR_LOSSLESS;
    static final TransferSyntax JPEG2000_LOSSLESS;
    static final TransferSyntax JPEG2000;
    static final TransferSyntax DEFLATED_EXPLICIT_LITTLEENDIAN;
    private static final TransferSyntax[] ALWAYS_SUPPORTED_INPUT;
    private static final TransferSyntax[] POSSIBLY_SUPPORTED_INPUT;
    private static final ImageReaderSpi JAI_JPEG_R_SPI;
    private static final ImageReaderSpi J2SE_JPEG_R_SPI;
    private static final ImageReaderSpi JAI_PREFERED_JPEG_R_SPI;
    private static final ImageReaderSpi DEFAULT_JPEG_R_SPI;
    private static final ImageReaderSpi DEFAULT_JPEG2000_R_SPI;
    private static final HashMap TS_R_SPI;
    static final TransferSyntax[] SUPPORTED_INPUT;
    private static final HashMap SUPPORTED_INPUT_HASH;
    static final TransferSyntax[] ALWAYS_SUPPORTED_OUTPUT;
    private static final TransferSyntax[] POSSIBLY_SUPPORTED_OUTPUT;
    private static final ImageWriterSpi JAI_JPEG_W_SPI;
    private static final ImageWriterSpi J2SE_JPEG_W_SPI;
    private static final ImageWriterSpi JAI_PREFERED_JPEG_W_SPI;
    private static final ImageWriterSpi DEFAULT_JPEG_W_SPI;
    private static final ImageWriterSpi DEFAULT_JPEG2000_W_SPI;
    private static final HashMap TS_W_SPI;
    static final TransferSyntax[] SUPPORTED_OUTPUT;
    static final ArrayList ALWAYS_SUPPORTED_OUTPUT_UIDLIST;
    static final ArrayList DEFAULT_UIDLIST;
    private static final HashMap SUPPORTED_OUTPUT_HASH;
    final String uid;
    final boolean bigEndian;
    final boolean encapsulated;
    final boolean explicitVR;

    private static ImageReaderWriterSpi getSpiByClassName(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (ImageReaderWriterSpi)IIORegistry.getDefaultInstance().getServiceProviderByClass(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static ImageReaderWriterSpi getSpiByFormat(final String string, Class clazz) {
        Iterator iterator = IIORegistry.getDefaultInstance().getServiceProviders(clazz, new ServiceRegistry.Filter(){

            public boolean filter(Object object) {
                String[] stringArray = ((ImageReaderWriterSpi)object).getFormatNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    return true;
                }
                return false;
            }
        }, true);
        if (!iterator.hasNext()) {
            return null;
        }
        return (ImageReaderWriterSpi)iterator.next();
    }

    static ArrayList getSupportedInputAsUidList() {
        ArrayList<String> arrayList = new ArrayList<String>(SUPPORTED_INPUT.length);
        for (int i = 0; i < SUPPORTED_INPUT.length; ++i) {
            arrayList.add(TransferSyntax.SUPPORTED_INPUT[i].uid);
        }
        return arrayList;
    }

    private static ArrayList getAlwaysSupportedOutputAsUidList() {
        ArrayList<String> arrayList = new ArrayList<String>(ALWAYS_SUPPORTED_OUTPUT.length);
        for (int i = 0; i < ALWAYS_SUPPORTED_OUTPUT.length; ++i) {
            arrayList.add(TransferSyntax.ALWAYS_SUPPORTED_OUTPUT[i].uid);
        }
        return arrayList;
    }

    final ImageReader getReader() {
        ImageReaderSpi imageReaderSpi = (ImageReaderSpi)TS_R_SPI.get(this);
        try {
            return imageReaderSpi.createReaderInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    final ImageWriterSpi getWriterSpi() {
        return (ImageWriterSpi)TS_W_SPI.get(this);
    }

    final ImageWriter getWriter() {
        try {
            return this.getWriterSpi().createWriterInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static final TransferSyntax getInstance(String string) throws DicomException {
        TransferSyntax transferSyntax = (TransferSyntax)SUPPORTED_INPUT_HASH.get(string);
        if (transferSyntax == null) {
            throw new DicomException("Unsupported", "Transfer Syntax: " + string);
        }
        return transferSyntax;
    }

    static final TransferSyntax[] intersectWithSupported(String[] stringArray) {
        ArrayList<TransferSyntax> arrayList = new ArrayList<TransferSyntax>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            TransferSyntax transferSyntax = (TransferSyntax)SUPPORTED_OUTPUT_HASH.get(stringArray[i]);
            if (transferSyntax == null) continue;
            arrayList.add(transferSyntax);
        }
        TransferSyntax[] transferSyntaxArray = new TransferSyntax[arrayList.size()];
        arrayList.toArray(transferSyntaxArray);
        return transferSyntaxArray;
    }

    private TransferSyntax(String string, boolean bl, boolean bl2, boolean bl3) {
        this.uid = string;
        this.bigEndian = bl;
        this.encapsulated = bl2;
        this.explicitVR = bl3;
    }

    public String toString() {
        return this.uid;
    }

    static {
        int n;
        RLE_COMPRESSION = new TransferSyntax("1.2.840.10008.1.2.5", false, true, true);
        EXPLICIT_BIGENDIAN = new TransferSyntax("1.2.840.10008.1.2.2", true, false, true);
        EXPLICIT_LITTLEENDIAN = new TransferSyntax("1.2.840.10008.1.2.1", false, false, true);
        IMPLICIT_LITTLEENDIAN = new TransferSyntax("1.2.840.10008.1.2", false, false, false);
        JPEG_EXTENDED_2_4 = new TransferSyntax("1.2.840.10008.1.2.4.51", false, true, true);
        JPEG_BASELINE_1 = new TransferSyntax("1.2.840.10008.1.2.4.50", false, true, true);
        JPEG_PROGRESSIVE_10_12 = new TransferSyntax("1.2.840.10008.1.2.4.55", false, true, true);
        JPEG_LOSSLESS_14 = new TransferSyntax("1.2.840.10008.1.2.4.57", false, true, true);
        JPEG_LOSSLESS_15 = new TransferSyntax("1.2.840.10008.1.2.4.58", false, true, true);
        JPEG_LOSSLESS_14SV1 = new TransferSyntax("1.2.840.10008.1.2.4.70", false, true, true);
        JPEG_LS_LOSSLESS = new TransferSyntax("1.2.840.10008.1.2.4.80", false, true, true);
        JPEG_LS_NEAR_LOSSLESS = new TransferSyntax("1.2.840.10008.1.2.4.81", false, true, true);
        JPEG2000_LOSSLESS = new TransferSyntax("1.2.840.10008.1.2.4.90", false, true, true);
        JPEG2000 = new TransferSyntax("1.2.840.10008.1.2.4.91", false, true, true);
        DEFLATED_EXPLICIT_LITTLEENDIAN = new TransferSyntax("1.2.840.10008.1.2.1.99", false, false, true);
        ALWAYS_SUPPORTED_INPUT = new TransferSyntax[]{RLE_COMPRESSION, EXPLICIT_BIGENDIAN, EXPLICIT_LITTLEENDIAN, IMPLICIT_LITTLEENDIAN};
        POSSIBLY_SUPPORTED_INPUT = new TransferSyntax[]{JPEG_EXTENDED_2_4, JPEG_BASELINE_1, JPEG_PROGRESSIVE_10_12, JPEG_LOSSLESS_14, JPEG_LOSSLESS_15, JPEG_LOSSLESS_14SV1, JPEG_LS_LOSSLESS, JPEG_LS_NEAR_LOSSLESS, JPEG2000_LOSSLESS, JPEG2000};
        JAI_JPEG_R_SPI = (ImageReaderSpi)TransferSyntax.getSpiByClassName("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReaderSpi");
        J2SE_JPEG_R_SPI = (ImageReaderSpi)TransferSyntax.getSpiByClassName("com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi");
        JAI_PREFERED_JPEG_R_SPI = JAI_JPEG_R_SPI == null ? J2SE_JPEG_R_SPI : JAI_JPEG_R_SPI;
        DEFAULT_JPEG_R_SPI = (ImageReaderSpi)TransferSyntax.getSpiByFormat("jpeg", ImageReaderSpi.class);
        Object object = (ImageReaderSpi)TransferSyntax.getSpiByClassName("com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLibSpi");
        if (object == null) {
            object = (ImageReaderSpi)TransferSyntax.getSpiByFormat("jpeg 2000", ImageReaderSpi.class);
        }
        DEFAULT_JPEG2000_R_SPI = object;
        TS_R_SPI = new HashMap();
        TS_R_SPI.put(JPEG_BASELINE_1, JAI_PREFERED_JPEG_R_SPI);
        TS_R_SPI.put(JPEG_EXTENDED_2_4, JAI_PREFERED_JPEG_R_SPI);
        TS_R_SPI.put(JPEG_LOSSLESS_14, JAI_JPEG_R_SPI);
        TS_R_SPI.put(JPEG_LOSSLESS_14SV1, JAI_JPEG_R_SPI);
        TS_R_SPI.put(JPEG_LOSSLESS_15, JAI_JPEG_R_SPI);
        TS_R_SPI.put(JPEG_LS_LOSSLESS, JAI_JPEG_R_SPI);
        TS_R_SPI.put(JPEG_LS_NEAR_LOSSLESS, JAI_JPEG_R_SPI);
        TS_R_SPI.put(JPEG_PROGRESSIVE_10_12, J2SE_JPEG_R_SPI);
        TS_R_SPI.put(JPEG2000_LOSSLESS, DEFAULT_JPEG2000_R_SPI);
        TS_R_SPI.put(JPEG2000, DEFAULT_JPEG2000_R_SPI);
        object = new ArrayList(ALWAYS_SUPPORTED_INPUT.length + POSSIBLY_SUPPORTED_INPUT.length);
        for (n = 0; n < ALWAYS_SUPPORTED_INPUT.length; ++n) {
            ((ArrayList)object).add(ALWAYS_SUPPORTED_INPUT[n]);
        }
        for (n = 0; n < POSSIBLY_SUPPORTED_INPUT.length; ++n) {
            if (TS_R_SPI.get(POSSIBLY_SUPPORTED_INPUT[n]) == null) continue;
            ((ArrayList)object).add(POSSIBLY_SUPPORTED_INPUT[n]);
        }
        SUPPORTED_INPUT = new TransferSyntax[((ArrayList)object).size()];
        ((ArrayList)object).toArray(SUPPORTED_INPUT);
        SUPPORTED_INPUT_HASH = new HashMap();
        for (int i = 0; i < SUPPORTED_INPUT.length; ++i) {
            SUPPORTED_INPUT_HASH.put(TransferSyntax.SUPPORTED_INPUT[i].uid, SUPPORTED_INPUT[i]);
        }
        ALWAYS_SUPPORTED_OUTPUT = new TransferSyntax[]{EXPLICIT_LITTLEENDIAN, EXPLICIT_BIGENDIAN, IMPLICIT_LITTLEENDIAN};
        POSSIBLY_SUPPORTED_OUTPUT = new TransferSyntax[]{JPEG_EXTENDED_2_4, JPEG_BASELINE_1, JPEG_LOSSLESS_14SV1, JPEG_LS_LOSSLESS, JPEG2000_LOSSLESS, JPEG2000};
        JAI_JPEG_W_SPI = (ImageWriterSpi)TransferSyntax.getSpiByClassName("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriterSpi");
        J2SE_JPEG_W_SPI = (ImageWriterSpi)TransferSyntax.getSpiByClassName("com.sun.imageio.plugins.jpeg.JPEGImageWriterSpi");
        JAI_PREFERED_JPEG_W_SPI = JAI_JPEG_W_SPI == null ? J2SE_JPEG_W_SPI : JAI_JPEG_W_SPI;
        DEFAULT_JPEG_W_SPI = (ImageWriterSpi)TransferSyntax.getSpiByFormat("jpeg", ImageWriterSpi.class);
        Object object2 = (ImageWriterSpi)TransferSyntax.getSpiByClassName("com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterCodecLibSpi");
        if (object2 == null) {
            object2 = (ImageWriterSpi)TransferSyntax.getSpiByFormat("jpeg 2000", ImageWriterSpi.class);
        }
        DEFAULT_JPEG2000_W_SPI = object2;
        TS_W_SPI = new HashMap();
        TS_W_SPI.put(JPEG_BASELINE_1, JAI_PREFERED_JPEG_W_SPI);
        TS_W_SPI.put(JPEG_EXTENDED_2_4, JAI_PREFERED_JPEG_W_SPI);
        TS_W_SPI.put(JPEG_LOSSLESS_14SV1, JAI_JPEG_W_SPI);
        TS_W_SPI.put(JPEG_LS_LOSSLESS, JAI_JPEG_W_SPI);
        TS_W_SPI.put(JPEG2000_LOSSLESS, DEFAULT_JPEG2000_W_SPI);
        TS_W_SPI.put(JPEG2000, DEFAULT_JPEG2000_W_SPI);
        object2 = new ArrayList(ALWAYS_SUPPORTED_OUTPUT.length + POSSIBLY_SUPPORTED_OUTPUT.length);
        for (n = 0; n < ALWAYS_SUPPORTED_OUTPUT.length; ++n) {
            ((ArrayList)object2).add(ALWAYS_SUPPORTED_OUTPUT[n]);
        }
        for (n = 0; n < POSSIBLY_SUPPORTED_OUTPUT.length; ++n) {
            if (TS_W_SPI.get(POSSIBLY_SUPPORTED_OUTPUT[n]) == null) continue;
            ((ArrayList)object2).add(POSSIBLY_SUPPORTED_OUTPUT[n]);
        }
        SUPPORTED_OUTPUT = new TransferSyntax[((ArrayList)object2).size()];
        ((ArrayList)object2).toArray(SUPPORTED_OUTPUT);
        ALWAYS_SUPPORTED_OUTPUT_UIDLIST = TransferSyntax.getAlwaysSupportedOutputAsUidList();
        DEFAULT_UIDLIST = new ArrayList(1);
        DEFAULT_UIDLIST.add("1.2.840.10008.1.2");
        SUPPORTED_OUTPUT_HASH = new HashMap();
        for (int i = 0; i < SUPPORTED_OUTPUT.length; ++i) {
            SUPPORTED_OUTPUT_HASH.put(TransferSyntax.SUPPORTED_OUTPUT[i].uid, SUPPORTED_OUTPUT[i]);
        }
    }
}

