/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.Util;
import fr.apteryx.imageio.dicom.VOIColorModel;
import java.awt.color.ColorSpace;
import java.lang.reflect.Array;

public final class VOILUTColorModel
extends VOIColorModel {
    private final int first;
    private final int last;
    private float[] flut;
    private byte[] blut;
    private final Object lut;

    public VOILUTColorModel(int n, int n2, int n3, Object object, ColorSpace colorSpace) {
        super(n, n2, 8, colorSpace);
        this.lut = object;
        this.first = n3;
        this.last = Array.getLength(object) - 1;
    }

    public int getFirst() {
        return this.first;
    }

    public Object getLUT() {
        return this.lut;
    }

    private synchronized void make_flut() {
        if (this.flut != null) {
            return;
        }
        float f = this.getColorSpace().getMinValue(0);
        float f2 = this.getColorSpace().getMaxValue(0);
        if (this.lut instanceof byte[]) {
            double d = (f2 - f) / 255.0f;
            this.blut = (byte[])this.lut;
            this.flut = new float[this.blut.length];
            for (int i = 0; i < this.blut.length; ++i) {
                this.flut[i] = (float)((double)f + (double)(this.blut[i] & 0xFF) * d);
                if (!(this.flut[i] > f2)) continue;
                this.flut[i] = f2;
            }
        } else {
            double d = (f2 - f) / (float)((1 << this.getPixelSize()) - 1);
            short[] sArray = Util.toShortArray(this.lut);
            this.flut = new float[sArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                this.flut[i] = (float)((double)f + (double)(sArray[i] & 0xFFFF) * d);
                if (!(this.flut[i] > f2)) continue;
                this.flut[i] = f2;
            }
        }
    }

    private synchronized void make_blut() {
        if (this.blut != null) {
            return;
        }
        if (this.lut instanceof byte[]) {
            this.blut = (byte[])this.lut;
        } else {
            short[] sArray = Util.toShortArray(this.lut);
            int n = this.getPixelSize() - 8;
            this.blut = new byte[sArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                this.blut[i] = (byte)(sArray[i] >> n);
            }
        }
    }

    int getComp(int n) {
        if (this.blut == null) {
            this.make_blut();
        }
        if ((n -= this.first) < 0) {
            n = 0;
        }
        if (n > this.last) {
            n = this.last;
        }
        return this.blut[n] & 0xFF;
    }

    int get255(int n) {
        return this.getComp(n);
    }

    float getNorm(int n) {
        if (this.flut == null) {
            this.make_flut();
        }
        if ((n -= this.first) < 0) {
            n = 0;
        }
        if (n > this.last) {
            n = this.last;
        }
        return this.flut[n];
    }

    int getDataElement(float f) {
        return this.last;
    }
}

