/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.VOIColorModel;
import java.awt.color.ColorSpace;

public final class VOIWindowColorModel
extends VOIColorModel {
    private final float cs_min;
    private final float cs_max;
    private final float w_center;
    private final float w_width;
    private final int x_low;
    private final int x_high;
    private final double slope;
    private final double intercept;
    private final double slope_unnorm;
    private final double intercept_unnorm;
    private final double slope_255;
    private final double intercept_255;

    public VOIWindowColorModel(int n, int n2, float f, float f2, ColorSpace colorSpace) {
        super(n, n2, n2, colorSpace);
        this.cs_min = colorSpace.getMinValue(0);
        this.cs_max = colorSpace.getMaxValue(0);
        this.w_center = f;
        this.w_width = f2;
        this.x_low = this.ceil((double)this.w_center - 0.5 - (double)((this.w_width - 1.0f) / 2.0f));
        this.x_high = this.floor((double)this.w_center - 0.5 + (double)((this.w_width - 1.0f) / 2.0f));
        this.slope = (this.cs_max - this.cs_min) / (this.w_width - 1.0f);
        this.intercept = (double)(this.cs_max - this.cs_min) * (0.5 - ((double)this.w_center - 0.5) / (double)(this.w_width - 1.0f)) + (double)this.cs_min;
        this.slope_unnorm = (float)this.unnorm_max_long / (this.w_width - 1.0f);
        this.intercept_unnorm = (double)this.unnorm_max_long * (0.5 - ((double)this.w_center - 0.5) / (double)(this.w_width - 1.0f));
        this.slope_255 = 255.0 / (double)(this.w_width - 1.0f);
        this.intercept_255 = 255.0 * (0.5 - ((double)this.w_center - 0.5) / (double)(this.w_width - 1.0f));
    }

    public int getMin() {
        return this.x_low;
    }

    public int getMax() {
        return this.x_high;
    }

    public float getCenter() {
        return this.w_center;
    }

    public float getWidth() {
        return this.w_width;
    }

    int getComp(int n) {
        double d = (double)n * this.slope_unnorm + this.intercept_unnorm + 0.5;
        return d < 0.0 ? 0 : (d > (double)this.unnorm_max_long ? this.unnorm_max : (int)d);
    }

    int get255(int n) {
        double d = (double)n * this.slope_255 + this.intercept_255 + 0.5;
        return d < 0.0 ? 0 : (d > 255.0 ? 255 : (int)d);
    }

    float getNorm(int n) {
        float f = (float)((double)n * this.slope + this.intercept);
        return f < this.cs_min ? this.cs_min : (f > this.cs_max ? this.cs_max : f);
    }

    int getDataElement(float f) {
        double d = ((double)f - this.intercept) / this.slope;
        int n = (int)(d > 0.0 ? d + 0.5 : d - 0.5);
        return n > this.x_high ? this.x_high : (n < this.x_low ? this.x_low : n);
    }

    private int ceil(double d) {
        int n = (int)d;
        if (d == (double)n) {
            return n;
        }
        return (int)(d < 0.0 ? d : d + 1.0);
    }

    private int floor(double d) {
        int n = (int)d;
        if (d == (double)n) {
            return n;
        }
        return (int)(d > 0.0 ? d : d - 1.0);
    }
}

