/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class ISO8601DateFormat
extends DateFormat {
    private int p = 0;

    public ISO8601DateFormat() {
        this.setCalendar(new GregorianCalendar());
    }

    public ISO8601DateFormat(TimeZone timeZone) {
        this();
        this.setTimeZone(timeZone);
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer fmtsb = new StringBuffer(20);
        Calendar cal = this.getCalendar();
        cal.setTime(date);
        int fieldStart = 0;
        int fieldEnd = fmtsb.append(ISO8601DateFormat.pad(cal.get(1), 4)).length();
        if (pos.getField() == 1) {
            ISO8601DateFormat.setFieldPosition(pos, fieldStart, fieldEnd);
        }
        fmtsb.append("-");
        fieldStart = fmtsb.length();
        fieldEnd = fmtsb.append(ISO8601DateFormat.pad(cal.get(2) + 1, 2)).length();
        if (pos.getField() == 2) {
            ISO8601DateFormat.setFieldPosition(pos, fieldStart, fieldEnd);
        }
        fmtsb.append("-");
        fieldStart = fmtsb.length();
        fieldEnd = fmtsb.append(ISO8601DateFormat.pad(cal.get(5), 2)).length();
        if (pos.getField() == 11) {
            ISO8601DateFormat.setFieldPosition(pos, fieldStart, fieldEnd);
        }
        fmtsb.append("T");
        fieldStart = fmtsb.length();
        fieldEnd = fmtsb.append(ISO8601DateFormat.pad(cal.get(11), 2)).length();
        if (pos.getField() == 5) {
            ISO8601DateFormat.setFieldPosition(pos, fieldStart, fieldEnd);
        }
        fmtsb.append(":");
        fieldStart = fmtsb.length();
        fieldEnd = fmtsb.append(ISO8601DateFormat.pad(cal.get(12), 2)).length();
        if (pos.getField() == 6) {
            ISO8601DateFormat.setFieldPosition(pos, fieldStart, fieldEnd);
        }
        fmtsb.append(":");
        fieldStart = fmtsb.length();
        fieldEnd = fmtsb.append(ISO8601DateFormat.pad(cal.get(13), 2)).length();
        if (pos.getField() == 7) {
            ISO8601DateFormat.setFieldPosition(pos, fieldStart, fieldEnd);
        }
        fieldStart = fieldEnd;
        int zoneOffsetMinutes = (cal.get(15) + cal.get(16)) / 60000;
        if (zoneOffsetMinutes == 0) {
            fieldEnd = fieldStart + 1;
            fmtsb.append("Z");
        } else {
            boolean neg;
            if (zoneOffsetMinutes < 0) {
                zoneOffsetMinutes = Math.abs(zoneOffsetMinutes);
                neg = true;
            } else {
                neg = false;
            }
            int hourOff = zoneOffsetMinutes / 60;
            int minOff = zoneOffsetMinutes % 60;
            fieldEnd = fmtsb.append((neg ? "-" : "+") + ISO8601DateFormat.pad(hourOff, 2) + ":" + ISO8601DateFormat.pad(minOff, 2)).length();
        }
        if (pos.getField() == 17) {
            ISO8601DateFormat.setFieldPosition(pos, fieldStart, fieldEnd);
        } else if (pos.getField() == 3) {
            ISO8601DateFormat.setFieldPosition(pos, 0, fieldEnd);
        }
        toAppendTo.append(fmtsb);
        return fmtsb;
    }

    private static StringBuffer pad(int num, int size) {
        if (num < 0) {
            throw new IllegalArgumentException("num can not be negative");
        }
        String snum = Integer.toString(num);
        StringBuffer sb = new StringBuffer(size);
        int n = size - snum.length();
        for (int i = 0; i < n; ++i) {
            sb.append('0');
        }
        sb.append(snum);
        return sb;
    }

    private static void setFieldPosition(FieldPosition pos, int startPos, int endPos) {
        pos.setBeginIndex(startPos);
        pos.setEndIndex(endPos);
    }

    public Date parse(String s, ParsePosition pos) {
        int original = pos.getIndex();
        try {
            s = s.substring(original);
            Date dt = this.parseDateTime(s);
            pos.setIndex(original + this.p);
            return dt;
        }
        catch (NoSuchElementException ne) {
            pos.setIndex(original);
            return null;
        }
        catch (ParseException pe) {
            pos.setIndex(original);
            return null;
        }
        catch (NumberFormatException nfe) {
            pos.setIndex(original);
            return null;
        }
    }

    private Date parseDateTime(String s) throws NoSuchElementException, NumberFormatException, ParseException {
        StringTokenizer st = new StringTokenizer(s, ".+-:TZz", true);
        boolean strict = !this.isLenient();
        int f = 1;
        this.p = 0;
        String tok = st.nextToken();
        this.p += tok.length();
        if ("+".equals(tok) || "-".equals(tok)) {
            if ("-".equals(tok)) {
                f = -1;
            }
            tok = st.nextToken();
        }
        int year = f * Integer.parseInt(tok);
        if (tok.length() < 4 && strict || !(tok = st.nextToken()).equals("-")) {
            throw new ParseException("invalid year", this.p);
        }
        this.p += tok.length();
        tok = st.nextToken();
        this.p += tok.length();
        int month = Integer.parseInt(tok);
        if (tok.length() != 2 && strict || month == 0 || month > 12 || !(tok = st.nextToken()).equals("-")) {
            throw new ParseException("invalid month", this.p);
        }
        this.p += tok.length();
        tok = st.nextToken();
        this.p += tok.length();
        int day = Integer.parseInt(tok);
        if (tok.length() != 2 && strict || day == 0 || day > 31 || !(tok = st.nextToken()).equals("T")) {
            throw new ParseException("invalid day", this.p);
        }
        this.p += tok.length();
        tok = st.nextToken();
        this.p += tok.length();
        int hour = Integer.parseInt(tok);
        if (tok.length() != 2 && strict || hour > 23 || !(tok = st.nextToken()).equals(":")) {
            throw new ParseException("invalid hour", this.p);
        }
        this.p += tok.length();
        tok = st.nextToken();
        this.p += tok.length();
        int min = Integer.parseInt(tok);
        if (tok.length() != 2 && strict || min > 59 || !(tok = st.nextToken()).equals(":")) {
            throw new ParseException("invalid minute", this.p);
        }
        this.p += tok.length();
        tok = st.nextToken();
        this.p += tok.length();
        int sec = Integer.parseInt(tok);
        if (tok.length() != 2 && strict || sec > 59) {
            throw new ParseException("invalid second", this.p);
        }
        this.p += tok.length();
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day, hour, min, sec);
        if (st.hasMoreTokens()) {
            tok = st.nextToken();
            this.p += tok.length();
            if (".".equals(tok)) {
                tok = st.nextToken();
                this.p += tok.length();
                int msec = Integer.parseInt(tok);
                if (tok.length() != 3) {
                    msec = (int)((double)msec * Math.pow(10.0, 3 - tok.length()) + 0.5);
                }
                cal.set(14, msec);
                tok = st.nextToken();
                this.p += tok.length();
            }
            if ("-".equals(tok) || "+".equals(tok) || "Z".equals(tok)) {
                int off = 0;
                if (!"Z".equals(tok)) {
                    f = "-".equals(tok) ? -1 : 1;
                    tok = st.nextToken();
                    this.p += tok.length();
                    off = Integer.parseInt(tok) * 3600 * 1000;
                    if (tok.length() != 2 && strict || !(tok = st.nextToken()).equals(":")) {
                        throw new ParseException("invalid zone hour offset length", this.p);
                    }
                    this.p += tok.length();
                    tok = st.nextToken();
                    this.p += tok.length();
                    off += Integer.parseInt(tok) * 60 * 1000;
                    if (tok.length() != 2 && strict) {
                        throw new ParseException("invalid zone min offset length", this.p);
                    }
                    off *= f;
                }
                ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
                cal.set(15, off);
            }
            if (st.hasMoreTokens() && strict) {
                throw new ParseException("extra tokens", this.p);
            }
        } else if (strict) {
            throw new ParseException("missing time zone", this.p);
        }
        return cal.getTime();
    }
}

