/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package open.dolphin.plugin;

import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;

/**
 *
 * @author oda
 */
public class LaboTestDocumentPanelPlugin implements IPlugin {

    private Type getType() {
        return IPlugin.Type.container;
    }

    private String getName() {
        return LaboTestDocumentPanel.TITLE;
    }

    private String getReadableName() {
        return "LaboTestDocumentPanel";
    }

    private IChartDocument panel(IChart parent) {
        return new LaboTestDocumentPanel(parent);
    }

    private Boolean update(Object object) {
        return false;
    }

    /**
     *
     * @param command
     * @param request
     * @param response
     * @return
     */
    @Override
    public boolean dispatchCommand(IPlugin.Command command, Object[] request, Object[] response) {
        switch (command) {
            case getType:
                response[0] = getType();
                break;
            case getName:
                response[0] = getName();
                break;
            case getReadableName:
                response[0] = getReadableName();
                break;
            case panel:
                response[0] = panel(((IChart) request[0]));
                break;
            case getFlavor:
                response[0] = null;
                break;
            case drop:
                break;
            case update:
                response[0] = update(request[0]);
                break;
            default:
                return false;
        }
        return true;
    }
}
