package open.dolphin.client;

import java.util.List;
import javax.swing.JTabbedPane;
import open.dolphin.helper.IChartCommandAccepter;

/**
 * チャートドキュメントが実装するインターフェイス。
 *
 * @author  Kazushi Minagawa, Digital Globe, Inc.
 */
public interface IChartDocument extends IChartCommandAccepter {

    /**
     *
     */
    public static enum TYPE {

        KarteViewerSingle,
        /**
         *
         */
        DocumentHistoryPanel,
    //    PatientInfoDocumentPanel,
        DiagnosisDocumentPanel,
    //    DoPanel,
     //   PhysicalPanel,
    //    PatientVisitInspector,
        KarteViewerDouble,
        DocumentBridgeImpl,
     //   AllergyPanel,
        /**
         *
         */
        CareMapDocumentPanel,
        /**
         *
         */
        PatientInspector,
        /**
         *
         */
        LetterViewer,
        /**
         *
         */
        LetterReplyImpl,
        /**
         *
         */
        ImageBrowserDocumentPanel,
     //   LaboTestDocumentPanel,
     //   MemoPanel,
        LetterImpl,
        KarteEditor,
        LetterReplyViewer,
        KarteDocumentViewer,
    //    MessagingPanel,
        Plugin
    };

    public TYPE getType();

    public String getTitle();

    public IChart getParentContext();

    public void start();

    public void stop();

    public void enter();

    public boolean prepare();

    public boolean update(Object o);

    /**
     *
     * @return
     */
    public boolean isDirty();

    /**
     *
     * @param dirty
     */
    public void setDirty(boolean dirty);

    public boolean itLayoutSaved();

    /**
     *
     * @return
     */
    public List<JTabbedPane> getTabbedPanels();
}
