package open.dolphin.client;

import open.dolphin.client.karte.template.Template;
import open.dolphin.infomodel.PVTHealthInsuranceModel;

/**
 * NewKarteParams
 *
 * @author  Kazushi Minagawa
 */
public final class NewKarteParams {

    private IChart.NewKarteOption option;    // ベースのカルテがあるかどうか、タブ及びEditorFrameの別、修正かどうか
    private IChart.NewKarteMode createMode;    // 空白、全コピー、前回処方適用のフラグ
    private String department;    // 診療科
    private String departmentCode;    // 診療科コード
    private Object[] insurances;    // 健康保険
    private int initialSelectedInsurance;    // 初期化時に選択する保険
    private PVTHealthInsuranceModel insurance;    // ダイアログでユーザが選択した保険
    private boolean openFrame;    // EditorFrame で編集するかどうかのフラグ 
    private String docType;    // 生成するドキュメントの種類    // 2号カルテ、シングル、紹介状等
    private String groupId;    // 不明
    private String confirmDate;    // 診療日
    private boolean isHospital;    //入院
    private Template selectedTemplate;

    /** Creates a new instance of NewKarteParams */
    public NewKarteParams(IChart.NewKarteOption option) {
        this.option = option;

        // MEMO: テンプレートを使用しないときは null にしておく
        selectedTemplate = null;
    }

    public IChart.NewKarteOption getOption() {
        return option;
    }

    public String getDocType() {
        return docType;
    }

    public String setDocType(String docType) {
        return this.docType = docType;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String val) {
        groupId = val;
    }

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String val) {
        department = val;
    }

    public String getDepartmentCode() {
        return departmentCode;
    }

    /**
     *
     * @param departmentCode
     */
    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    /**
     *
     * @return
     */
    public Object[] getInsurances() {
        return insurances;
    }

    public void setInsurances(Object[] ins) {
        insurances = ins;
    }

    public PVTHealthInsuranceModel getPVTHealthInsurance() {
        return insurance;
    }

    public void setPVTHealthInsurance(PVTHealthInsuranceModel val) {
        insurance = val;
    }

    public void setOpenFrame(boolean openFrame) {
        this.openFrame = openFrame;
    }

    public boolean isOpenFrame() {
        return openFrame;
    }

    public IChart.NewKarteMode getCreateMode() {
        return createMode;
    }

    public void setCreateMode(IChart.NewKarteMode createMode) {
        this.createMode = createMode;
    }

    public int getInitialSelectedInsurance() {
        return initialSelectedInsurance;
    }

    public void setInitialSelectedInsurance(int index) {
        initialSelectedInsurance = index;
    }

    public String getConfirmDate() {
        return confirmDate;
    }

    public void setConfirmDate(String s) {
        confirmDate = s;
    }

    public boolean isHospital() {
        return isHospital;
    }

    public void setHospital(boolean s) {
        isHospital = s;
    }

    /**
     *
     * @return
     */
    public Template getSelectedTemplate() {
        return selectedTemplate;
    }

    /**
     *
     * @param template
     */
    public void setSelectedTemplate(Template template) {
        selectedTemplate = template;
    }
}
