/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * StatusPanel.java
 *
 * Created on 2010/03/04, 17:12:58
 */
package open.dolphin.client;

import open.dolphin.project.GlobalConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;

import java.beans.PropertyChangeEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import org.jdesktop.application.TaskMonitor;
import java.beans.PropertyChangeListener;

/**
 *
 * @author oda
 */
public class StatusPanel extends javax.swing.JPanel implements PropertyChangeListener {

    private static final int DEFAULT_HEIGHT = 23;
    private TaskMonitor taskMonitor;
    private JLabel timelabel;
    private boolean useTime = true;

    /** Creates new form StatusPanel */
    public StatusPanel() {
        this(true);
    }

    public StatusPanel(boolean useTime) {
        initComponents();
        this.useTime = useTime;

        Font font = new Font("Dialog", Font.PLAIN, 10);
        leftLabel.setFont(font);
        rightLabel.setFont(font);

        leftLabel.setHorizontalAlignment(SwingConstants.CENTER);
        rightLabel.setHorizontalAlignment(SwingConstants.CENTER);

        if (useTime) {
            timelabel = new JLabel("経過時間: 00 秒");
            timelabel.setFont(font);
            timelabel.setHorizontalAlignment(SwingConstants.CENTER);
        }

        info.add(Box.createHorizontalStrut(3));
        info.add(leftLabel);
        info.add(new SeparatorPanel());
        info.add(rightLabel);
        if (useTime) {
            info.add(new SeparatorPanel());
            info.add(timelabel);
        }
        info.add(Box.createHorizontalStrut(11));
        //  this.setLayout(new BorderLayout());
        //  this.add(info, BorderLayout.CENTER);
        this.setPreferredSize(new Dimension(getWidth(), DEFAULT_HEIGHT));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        rightLabel = new javax.swing.JLabel();
        leftLabel = new javax.swing.JLabel();
        messageLable = new javax.swing.JLabel();
        info = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        rightLabel.setName("rightLabel"); // NOI18N
        add(rightLabel, java.awt.BorderLayout.CENTER);

        leftLabel.setName("leftLabel"); // NOI18N
        add(leftLabel, java.awt.BorderLayout.PAGE_END);

        messageLable.setName("messageLable"); // NOI18N
        add(messageLable, java.awt.BorderLayout.LINE_END);

        info.setName("info"); // NOI18N
        info.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT, 0, 2));
        add(info, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel info;
    private javax.swing.JLabel leftLabel;
    private javax.swing.JLabel messageLable;
    private javax.swing.JLabel rightLabel;
    // End of variables declaration//GEN-END:variables

    public void setMessage(String msg) {
        messageLable.setText(msg);
    }

    private BlockGlass getBlock() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null && window instanceof JFrame) {
            JFrame frame = (JFrame) window;
            //<TODO>アイコンを適切な物に変更
            ImageIcon icon = GlobalConstants.getImageIcon("web_32.gif");
            frame.setIconImage(icon.getImage());

            Component cmp = frame.getGlassPane();
            if (cmp != null && cmp instanceof BlockGlass) {
                return (BlockGlass) cmp;
            }
        }
        return null;
    }

    private void start() {
        BlockGlass glass = getBlock();
        if (glass != null) {
            glass.block();
        }
    }

    private void stop() {
        BlockGlass glass = getBlock();
        if (glass != null) {
            glass.unblock();
        }
        //ultraSonic.stop();
    }

    /**
     *
     * @param info
     */
    public void setRightInfo(String info) {
        rightLabel.setText(info);
    }

    public void setLeftInfo(String info) {
        leftLabel.setText(info);
    }

    public void setTimeInfo(long time) {
        if (useTime) {
            StringBuilder sb = new StringBuilder();
            sb.append("経過時間: ");
            sb.append(time);
            sb.append(" 秒");
            timelabel.setText(sb.toString());
        }
    }

    /**
     *
     * @param taskMonitor
     */
    public void ready(TaskMonitor taskMonitor) {
        taskMonitor.addPropertyChangeListener(this);
        this.taskMonitor = taskMonitor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {

        String propertyName = e.getPropertyName();

        if ("started".equals(propertyName)) {
            this.start();

        } else if ("done".equals(propertyName)) {
            this.stop();
            this.taskMonitor.removePropertyChangeListener(this); // 重要
        }
    }
}
