/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * BasicInfoPanel.java
 *
 * Created on 2009/08/26, 14:47:16
 */

package open.dolphin.client.karte;

import java.awt.Color;
import open.dolphin.client.IChart;
import open.dolphin.project.GlobalSettings;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.SimpleAddressModel;

/**
 *　カルテの左側に表示される患者さんの情報
 * @author
 */
public class BasicInfoPanel extends javax.swing.JPanel {

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        nameLabel = new javax.swing.JLabel();
        addressLabel = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createEtchedBorder());
        setPreferredSize(new java.awt.Dimension(270, 40));
        setLayout(new java.awt.BorderLayout());

        nameLabel.setForeground(new java.awt.Color(20, 20, 140));
        nameLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        nameLabel.setName("nameLabel"); // NOI18N
        nameLabel.setOpaque(true);
        add(nameLabel, java.awt.BorderLayout.NORTH);

        addressLabel.setForeground(new java.awt.Color(20, 20, 140));
        addressLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        addressLabel.setName("addressLabel"); // NOI18N
        addressLabel.setOpaque(true);
        add(addressLabel, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel addressLabel;
    private javax.swing.JLabel nameLabel;
    // End of variables declaration//GEN-END:variables

    private Color maleColor;
    private Color femaleColor;
    private Color unknownColor;

    // Context このインスペクタの親コンテキスト
    private IChart parent;

    /**
     * BasicInfoInspectorオブジェクトを生成する。
     */
    public BasicInfoPanel(IChart parent) {
        this.parent = parent;
        maleColor = GlobalSettings.getColors(GlobalSettings.Parts.MALE); // Color.CYAN;
        femaleColor = GlobalSettings.getColors(GlobalSettings.Parts.FEMALE); // Color.PINK;
        unknownColor = GlobalSettings.getColors(GlobalSettings.Parts.UNKNOWN); // Color.LIGHT_GRAY;
        initComponents();
        update();
    }

    /**
     * 患者の基本情報を表示する。
     */
    private void update() {

        StringBuilder sb = new StringBuilder();
        sb.append(parent.getPatient().getFullName());
        sb.append("  ");
        sb.append(parent.getPatient().getAgeBirthday());
        nameLabel.setText(sb.toString());

        SimpleAddressModel address = parent.getPatient().getAddress();
        if (address != null) {
            addressLabel.setText(address.getAddress());
        } else {
            addressLabel.setText("　");
        }

        String gender = parent.getPatient().getGenderDesc();

        Color color = null;
        if (gender.equals(IInfoModel.MALE_DISP)) {
            color = maleColor;
        } else if (gender.equals(IInfoModel.FEMALE_DISP)) {
            color = femaleColor;
        } else {
            color = unknownColor;
        }
        nameLabel.setBackground(color);
        addressLabel.setBackground(color);
        setBackground(color);
    }

}
