/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ClaimSettingPanel.java
 *
 * 環境設定　レセコン
 *
 * Created on 2010/03/09, 17:41:20
 */
package open.dolphin.client.settings;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import open.dolphin.project.GlobalSettings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;

import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.RegexConstrainedDocument;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.Adapter;

/**
 *
 * @author
 */
public class ClaimSettingPanel extends javax.swing.JPanel implements IAbstractSettingPanel {

    private ProjectSettingDialog context;
    //  private GlobalVariablesImplement projectGlobalVariables;
    private PropertyChangeSupport boundSupport;
    private State state = State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private static final String ID = "claimSetting";
    private static final String TITLE = "レセコン";
    private static final String ICON = "calculator.png";
    /** 画面モデル */
    private ClaimModel model;
    private StateMgr stateMgr;
    private Adapter<Boolean, Boolean> adapter;

    /** Creates new form ClaimSettingPanel */
    public ClaimSettingPanel() {
        boundSupport = new PropertyChangeSupport(this);
        model = new ClaimModel();
        initComponents();

        setId(ID);
        setTitle(TITLE);
        setIcon(ICON);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        bg1 = new javax.swing.ButtonGroup();
        bg2 = new javax.swing.ButtonGroup();
        jTextField1 = new javax.swing.JTextField();
        sendClaim = new javax.swing.JPanel();
        panel1 = new javax.swing.JPanel();
        label1 = new javax.swing.JLabel();
        sendClaimYes = new javax.swing.JRadioButton();
        sendClaimNo = new javax.swing.JRadioButton();
        port = new javax.swing.JPanel();
        label2 = new javax.swing.JLabel();
        claimHostCombo = new javax.swing.JComboBox();
        label3 = new javax.swing.JLabel();
        vPanel = new javax.swing.JPanel();
        label5 = new javax.swing.JLabel();
        jmariField = new javax.swing.JTextField();
        label6 = new javax.swing.JLabel();
        claimAddressField = new javax.swing.JTextField();
        label7 = new javax.swing.JLabel();
        claimPortField = new javax.swing.JTextField();
        v34 = new javax.swing.JRadioButton();
        v40 = new javax.swing.JRadioButton();
        code = new javax.swing.JComboBox();
        Label = new javax.swing.JLabel();
        pvt = new javax.swing.JPanel();
        useAsPVTServer = new javax.swing.JCheckBox();

        jTextField1.setText("jTextField1");
        jTextField1.setName("jTextField1"); // NOI18N

        sendClaim.setBorder(javax.swing.BorderFactory.createTitledBorder("CLAIM（請求データ）送信"));
        sendClaim.setName("sendClaim"); // NOI18N
        sendClaim.setLayout(new java.awt.BorderLayout());

        panel1.setName("panel1"); // NOI18N
        panel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 0, 5));

        label1.setText("診療行為送信:");
        label1.setName("label1"); // NOI18N
        panel1.add(label1);

        bg1.add(sendClaimYes);
        sendClaimYes.setText("送信する");
        sendClaimYes.setName("sendClaimYes"); // NOI18N
        sendClaimYes.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sendClaimYesActionPerformed(evt);
            }
        });
        sendClaimYes.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                sendClaimYesPropertyChange(evt);
            }
        });
        panel1.add(sendClaimYes);

        bg1.add(sendClaimNo);
        sendClaimNo.setText("送信しない");
        sendClaimNo.setName("sendClaimNo"); // NOI18N
        sendClaimNo.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                sendClaimNoStateChanged(evt);
            }
        });
        sendClaimNo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sendClaimNoActionPerformed(evt);
            }
        });
        panel1.add(sendClaimNo);

        sendClaim.add(panel1, java.awt.BorderLayout.PAGE_START);

        port.setBorder(javax.swing.BorderFactory.createTitledBorder("レセコン情報"));
        port.setName("port"); // NOI18N

        label2.setText("機種:");
        label2.setName("label2"); // NOI18N

        claimHostCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "日医標準レセコン(ORCA)" }));
        claimHostCombo.setName("claimHostCombo"); // NOI18N
        claimHostCombo.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                claimHostComboPropertyChange(evt);
            }
        });

        label3.setText("バージョン:");
        label3.setName("label3"); // NOI18N

        vPanel.setName("vPanel"); // NOI18N
        vPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 5, 0));

        label5.setText("医療機関ID:  JPN\"");
        label5.setName("label5"); // NOI18N

        jmariField.setColumns(10);
        jmariField.setToolTipText("医療機関コードの数字部分のみ12桁を入力してください。");
        jmariField.setName("jmariField"); // NOI18N

        label6.setText("IPアドレス:");
        label6.setName("label6"); // NOI18N

        claimAddressField.setColumns(10);
        claimAddressField.setName("claimAddressField"); // NOI18N
        claimAddressField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                claimAddressFieldPropertyChange(evt);
            }
        });

        label7.setText("ポート番号:");
        label7.setName("label7"); // NOI18N

        claimPortField.setColumns(5);
        claimPortField.setName("claimPortField"); // NOI18N
        claimPortField.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                claimPortFieldPropertyChange(evt);
            }
        });

        bg2.add(v34);
        v34.setText("3.4");
        v34.setName("v34"); // NOI18N
        v34.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                v34ActionPerformed(evt);
            }
        });
        v34.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                v34PropertyChange(evt);
            }
        });

        bg2.add(v40);
        v40.setText("4.0以降");
        v40.setName("v40"); // NOI18N
        v40.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                v40ActionPerformed(evt);
            }
        });
        v40.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                v40PropertyChange(evt);
            }
        });

        code.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "UTF-8", "Shift_JIS", "EUC-JP" }));
        code.setName("code"); // NOI18N
        code.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                codePropertyChange(evt);
            }
        });

        Label.setText("エンコード");
        Label.setName("Label"); // NOI18N

        javax.swing.GroupLayout portLayout = new javax.swing.GroupLayout(port);
        port.setLayout(portLayout);
        portLayout.setHorizontalGroup(
            portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(portLayout.createSequentialGroup()
                .addGap(47, 47, 47)
                .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(portLayout.createSequentialGroup()
                        .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(label2)
                            .addComponent(label3))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(portLayout.createSequentialGroup()
                                .addComponent(v34)
                                .addGap(5, 5, 5)
                                .addComponent(v40)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(vPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(claimHostCombo, javax.swing.GroupLayout.PREFERRED_SIZE, 126, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(portLayout.createSequentialGroup()
                        .addComponent(label5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jmariField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(portLayout.createSequentialGroup()
                        .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(label6)
                            .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(Label)
                                .addComponent(label7)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(claimPortField, javax.swing.GroupLayout.PREFERRED_SIZE, 72, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(claimAddressField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(code, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(147, Short.MAX_VALUE))
        );
        portLayout.setVerticalGroup(
            portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(portLayout.createSequentialGroup()
                .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(claimHostCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(label2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(vPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(label3)
                    .addComponent(v34)
                    .addComponent(v40))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(label5)
                    .addComponent(jmariField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(10, 10, 10)
                .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(label6)
                    .addComponent(claimAddressField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(label7)
                    .addComponent(claimPortField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(portLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(code, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(Label))
                .addContainerGap(19, Short.MAX_VALUE))
        );

        pvt.setBorder(javax.swing.BorderFactory.createTitledBorder("受付情報の受信"));
        pvt.setName("pvt"); // NOI18N
        pvt.setLayout(new java.awt.BorderLayout());

        useAsPVTServer.setText("このマシンでORCAからの受付情報を受信する");
        useAsPVTServer.setToolTipText("このマシンでORCAからの受付情報を受信する場合はチェックしてください");
        useAsPVTServer.setName("useAsPVTServer"); // NOI18N
        useAsPVTServer.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                useAsPVTServerPropertyChange(evt);
            }
        });
        pvt.add(useAsPVTServer, java.awt.BorderLayout.CENTER);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(sendClaim, javax.swing.GroupLayout.DEFAULT_SIZE, 408, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(pvt, javax.swing.GroupLayout.DEFAULT_SIZE, 384, Short.MAX_VALUE)
                .addContainerGap())
            .addComponent(port, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(sendClaim, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(port, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pvt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void sendClaimYesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sendClaimYesActionPerformed
        stateMgr.controlClaim();
    }//GEN-LAST:event_sendClaimYesActionPerformed

    private void sendClaimNoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sendClaimNoActionPerformed
        stateMgr.controlClaim();
    }//GEN-LAST:event_sendClaimNoActionPerformed

    private void v34ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_v34ActionPerformed
        stateMgr.controlVersion();
    }//GEN-LAST:event_v34ActionPerformed

    private void v40ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_v40ActionPerformed
        stateMgr.controlVersion();
    }//GEN-LAST:event_v40ActionPerformed

    private void sendClaimYesPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_sendClaimYesPropertyChange

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }

    }//GEN-LAST:event_sendClaimYesPropertyChange

    private void sendClaimNoStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_sendClaimNoStateChanged

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }

    }//GEN-LAST:event_sendClaimNoStateChanged

    private void claimHostComboPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_claimHostComboPropertyChange

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }

    }//GEN-LAST:event_claimHostComboPropertyChange

    private void v34PropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_v34PropertyChange

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }

    }//GEN-LAST:event_v34PropertyChange

    private void v40PropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_v40PropertyChange

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }

    }//GEN-LAST:event_v40PropertyChange

    private void claimAddressFieldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_claimAddressFieldPropertyChange
        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }
    }//GEN-LAST:event_claimAddressFieldPropertyChange

    private void claimPortFieldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_claimPortFieldPropertyChange
        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
               LogWriter.error(getClass(), ex);
            }
        }
    }//GEN-LAST:event_claimPortFieldPropertyChange

    private void codePropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_codePropertyChange
        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }
    }//GEN-LAST:event_codePropertyChange

    private void useAsPVTServerPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_useAsPVTServerPropertyChange
        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }
    }//GEN-LAST:event_useAsPVTServerPropertyChange
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel Label;
    private javax.swing.ButtonGroup bg1;
    private javax.swing.ButtonGroup bg2;
    private javax.swing.JTextField claimAddressField;
    private javax.swing.JComboBox claimHostCombo;
    private javax.swing.JTextField claimPortField;
    private javax.swing.JComboBox code;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jmariField;
    private javax.swing.JLabel label1;
    private javax.swing.JLabel label2;
    private javax.swing.JLabel label3;
    private javax.swing.JLabel label5;
    private javax.swing.JLabel label6;
    private javax.swing.JLabel label7;
    private javax.swing.JPanel panel1;
    private javax.swing.JPanel port;
    private javax.swing.JPanel pvt;
    private javax.swing.JPanel sendClaim;
    private javax.swing.JRadioButton sendClaimNo;
    private javax.swing.JRadioButton sendClaimYes;
    private javax.swing.JCheckBox useAsPVTServer;
    private javax.swing.JRadioButton v34;
    private javax.swing.JRadioButton v40;
    private javax.swing.JPanel vPanel;
    // End of variables declaration//GEN-END:variables

    @Override
    public void onChenge(Adapter<Boolean, Boolean> adapter) {
        this.adapter = adapter;
    }

    /**
     * GUI 及び State を生成する。
     */
    @Override
    public void start() {

        model.populate();
        initCustomComponents();
        connect();
        bindModelToView();
    }

    /**
     * 設定値を保存する。
     */
    @Override
    public void save() {
        bindViewToModel();
        model.restore();
    }

    /**
     * GUIを構築する
     */
    private void initCustomComponents() {

        if (GlobalSettings.isTrial()) {
            jmariField.setEditable(false);
            jmariField.setVisible(false);
            label5.setText("医療機関ID:  JPN:編集不可");
        }

        if (GlobalSettings.isTrial()) {
            claimAddressField.setEditable(false);
            claimAddressField.setVisible(false);
            claimAddressField.setText("dolphin.good-day.co.jp");
            label6.setText("IPアドレス:編集不可");
        }

        if (GlobalSettings.isTrial()) {
            claimPortField.setEditable(false);
            claimPortField.setVisible(false);
            label7.setText("ポート番号:編集不可");
        }
    }

    /**
     * リスナを接続する。
     */
    private void connect() {

        stateMgr = new StateMgr();

        DocumentListener dl = new DocumentListener() {

            @Override
            public void insertUpdate(DocumentEvent e) {
                stateMgr.checkState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                stateMgr.checkState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                stateMgr.checkState();
            }
        };

        String jmariPattern = "[0-9]*";
        RegexConstrainedDocument jmariDoc = new RegexConstrainedDocument(jmariPattern);
        jmariField.setDocument(jmariDoc);
        jmariField.getDocument().addDocumentListener(dl);

        jmariField.addFocusListener(AutoRomanListener.getInstance());


        String portPattern = "[0-9]*";
        RegexConstrainedDocument portDoc = new RegexConstrainedDocument(portPattern);
        claimPortField.setDocument(portDoc);
        claimPortField.getDocument().addDocumentListener(dl);

        claimPortField.addFocusListener(AutoRomanListener.getInstance());


        String ipPattern = "[A-Za-z0-9.]*";
        RegexConstrainedDocument ipDoc = new RegexConstrainedDocument(ipPattern);
        claimAddressField.setDocument(ipDoc);
        claimAddressField.getDocument().addDocumentListener(dl);

        claimAddressField.addFocusListener(AutoRomanListener.getInstance());

    }

    /**
     * ModelToView
     */
    private void bindModelToView() {
        //
        // 診療行為送信を選択する
        //
        boolean sending = model.isSendClaim();
        sendClaimYes.setSelected(sending);
        sendClaimNo.setSelected(!sending);
        claimPortField.setEnabled(sending);

        // バージョン 選択
        String ver = model.getVersion();
        if (ver.startsWith("4")) {
            v40.setSelected(true);
        } else {
            v34.setSelected(true);
        }

        // JMARICode
        String jmari = model.getJmariCode();
        jmari = jmari != null ? jmari : "";
        if (!jmari.equals("") && jmari.startsWith("JPN")) {
            jmari = jmari.substring(3);
            jmariField.setText(jmari);
        }

        // CLAIM ホストのIPアドレスを設定する
        String val = model.getClaimAddress();
        val = val != null ? val : "";
        claimAddressField.setText(val);

        // CLAIM ホストのポート番号を設定する
        val = String.valueOf(model.getClaimPort());
        val = val != null ? val : "";
        claimPortField.setText(val);

        val = model.getClaimHostName();        // ホスト名
        val = val != null ? val : "";
        claimHostCombo.setSelectedItem(val);
        useAsPVTServer.setSelected(model.isUseAsPVTServer());  // 受付受信
        code.setSelectedIndex(model.getCharacterCode());
    }

    /**
     * ViewToModel
     */
    private void bindViewToModel() {

        // 診療行為送信、仮保存時、修正時、病名送信
        // の設定を保存する
        //      model.setSendClaim(sendClaimYes.isSelected());

        // バージョン
        if (v40.isSelected()) {
            model.setVersion("40");
        } else {
            model.setVersion("34");
        }

        // JMARI
        String jmari = jmariField.getText().trim();
        if (!jmari.equals("")) {
            model.setJmariCode("JPN" + jmari);
        } else {
            model.setJmariCode(null);
        }

        // ホスト名を保存する
        String val = (String) claimHostCombo.getSelectedItem();
        model.setClaimHostName(val);

        // IPアドレスを保存する
        val = claimAddressField.getText().trim();
        model.setClaimAddress(val);

        // ポート番号を保存する
        val = claimPortField.getText().trim();
        try {
            int _port = Integer.parseInt(val);
            model.setClaimPort(_port);

        } catch (NumberFormatException e) {
            model.setClaimPort(5001);
        }

        model.setUseAsPVTServer(useAsPVTServer.isSelected());  // 受付受信を保存する

        model.setCharacterCode(code.getSelectedIndex());
    }

    @Override
    public String getId() {
        return id;
    }

    /**
     *
     * @param id
     */
    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return title;
    }

    /**
     *
     * @param title
     */
    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIcon() {
        return icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public ProjectSettingDialog getContext() {
        return context;
    }

    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener(STATE_PROP, context);
        this.setLogInState(context.getLoginState());
    }

    @Override
    public boolean isLoginState() {
        return loginState;
    }

    @Override
    public void setLogInState(boolean login) {
        loginState = login;
    }

    /**
     *
     * @return
     */
    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {

        boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {

        boundSupport.removePropertyChangeListener(prop, l);
    }

    /**
     * @param state The state to set.
     */
    @Override
    public void setState(State state) {
        this.state = state;
        boundSupport.firePropertyChange(STATE_PROP, null, this.state);
    }

    /**
     * @return Returns the state.
     */
    @Override
    public State getState() {
        return state;
    }

    /**
     * 画面も出るクラス。
     */
    class ClaimModel {

        private boolean sendClaim;
        private String claimHostName;
        private String version;
        private String jmariCode;
        private String claimAddress;
        private int claimPort;
        private boolean useAsPvtServer;
        private int character_code;

        protected void populate() {
            setSendClaim(GlobalVariables.getSendClaim());            // 診療行為送信
            setSendClaim(true);            // 診療行為送信
            setVersion(GlobalVariables.getOrcaVersion());            // バージョン
            setJmariCode(GlobalVariables.getJMARICode());         // JMARI code
            setClaimAddress(GlobalVariables.getClaimAddress());    // CLAIM ホストのIPアドレス
            setClaimPort(GlobalVariables.getClaimPort());     // CLAIM ホストのポート番号
            setClaimHostName(GlobalVariables.getClaimHostName());        // ホスト名
            setUseAsPVTServer(GlobalVariables.getUseAsPVTServer());          // 受付受信
            setCharacterCode(GlobalVariables.getCharacterCode());
        }

        private void restore() {
            GlobalVariables.setSendClaim(isSendClaim());   // 診療行為送信
            GlobalVariables.setSendClaim(true);   // 診療行為送信

            GlobalVariables.setOrcaVersion(getVersion());  // バージョン
            GlobalVariables.setJMARICode(getJmariCode());        // JMARI
            GlobalVariables.setClaimAddress(getClaimAddress());   // CLAIM ホストのIPアドレス
            GlobalVariables.setClaimPort(getClaimPort());   // CLAIM ホストのポート番号
            GlobalVariables.setClaimHostName(getClaimHostName());        // ホスト名
            GlobalVariables.setUseAsPVTServer(isUseAsPVTServer());        // 受付受信
            GlobalVariables.setCharacterCode(getCharacterCode());
        }

        private boolean isSendClaim() {
            return sendClaim;
        }

        private void setSendClaim(boolean sendClaim) {
            this.sendClaim = sendClaim;
        }

        private boolean isUseAsPVTServer() {
            return useAsPvtServer;
        }

        private void setUseAsPVTServer(boolean useAsPvtServer) {
            this.useAsPvtServer = useAsPvtServer;
        }

        private String getClaimHostName() {
            return claimHostName;
        }

        private void setClaimHostName(String claimHostName) {
            this.claimHostName = claimHostName;
        }

        private String getClaimAddress() {
            return claimAddress;
        }

        private void setClaimAddress(String claimAddress) {
            this.claimAddress = claimAddress;
        }

        private int getClaimPort() {
            return claimPort;
        }

        private void setClaimPort(int claimPort) {
            this.claimPort = claimPort;
        }

        private String getVersion() {
            return version;
        }

        private void setVersion(String version) {
            this.version = version;
        }

        private String getJmariCode() {
            return jmariCode;
        }

        private void setJmariCode(String jmariCode) {
            this.jmariCode = jmariCode;
        }

        /**
         * @return the character_code
         */
        public int getCharacterCode() {
            return character_code;
        }

        /**
         * @param character_code the character_code to set
         */
        public void setCharacterCode(int character_code) {
            this.character_code = character_code;
        }
    }

    class StateMgr {

        private void checkState() {

            State newState = isValid()
                    ? State.VALID_STATE
                    : State.INVALID_STATE;
            if (newState != state) {
                setState(newState);
            }
        }

        private void controlClaim() {

            // 診療行為の送信を行う場合のみ
            // 仮保存、修正、病名送信、ホスト選択、ポートがアクティブになる
            boolean b = sendClaimYes.isSelected();
            claimPortField.setEnabled(b);
            this.checkState();
        }

        private void controlVersion() {

            boolean b = v40.isSelected();
            jmariField.setEnabled(b);
            this.checkState();
        }

        private boolean isValid() {

            boolean jmariOk = false;
            boolean claimAddrOk = false;
            boolean claimPortOk = false;

            if (v40.isSelected()) {
                String code = jmariField.getText().trim();
                if (!code.equals("") && code.length() == 12) {
                    jmariOk = true;
                }
            } else {
                jmariOk = true;
            }

            if (sendClaimYes.isSelected()) {
                claimAddrOk = (claimAddressField.getText().trim().equals("")) ? false : true;
                claimPortOk = (claimPortField.getText().trim().equals("")) ? false : true;
            } else {
                claimAddrOk = true;
                claimPortOk = true;
            }

            return (jmariOk && claimAddrOk && claimPortOk) ? true : false;
        }
    }
}
