/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package open.dolphin.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import open.dolphin.plugin.IPlugin;
import java.util.HashMap;
import open.dolphin.log.LogWriter;
import open.dolphin.plugin.PluginLoader;
import open.dolphin.plugin.PluginWrapper;

/**
 * PlugInMenuSupport
 */
public class PlugInMenuSupport extends HashMap<String, IPlugin> {

    public PlugInMenuSupport() {
        super();
    }

    public void add(IPlugin plugin) {
        PluginWrapper pluginWrapper = new PluginWrapper(plugin);
        this.put(pluginWrapper.getName(), plugin);
    }

    public boolean execute(String name, Object[] request, Object[] response) {
        if (get(name).dispatchCommand(IPlugin.Command.execute, request, response)) {
            return true;
        }
        return false;
    }

    private void deletePlugins(File source) throws Exception {
        File[] sourceFiles = source.listFiles();
        for (int i = 0; i < sourceFiles.length; i++) {
            File sourceFile = sourceFiles[i];
            String sourceFileName = sourceFile.getName();
            if (sourceFileName.substring(sourceFileName.length() - 4, sourceFileName.length()).equals(".jar")) {
                sourceFile.delete();

            }
        }
    }

    private void copyPlugins(File source, File dist) throws Exception {
        File[] sourceFiles = source.listFiles();
        for (int i = 0; i < sourceFiles.length; i++) {
            File sourceFile = sourceFiles[i];
            String sourceFileName = sourceFile.getName();
            if (sourceFileName.substring(sourceFileName.length() - 4, sourceFileName.length()).equals(".jar")) {
                FileInputStream sourceStream = null;
                FileOutputStream distStream = null;
                FileChannel sourceChannel = null;
                FileChannel distChannel = null;
                try {
                    sourceStream = new FileInputStream(sourceFile);
                    distStream = new FileOutputStream(dist.getAbsolutePath() + File.separator + sourceFile.getName());
                    sourceChannel = sourceStream.getChannel();
                    distChannel = distStream.getChannel();
                    sourceChannel.transferTo(0, sourceChannel.size(), distChannel);
                } catch (IOException ex) {
                      LogWriter.error(getClass(), ex);
                } finally {
                    sourceStream.close();
                    distStream.close();
                    sourceChannel.close();
                    distChannel.close();
                }
            }
        }
    }

    private void movePlugins(File source, File dist) {
        try {
            copyPlugins(source, dist);
            deletePlugins(source);
        } catch (Exception ex) {
              LogWriter.error(getClass(), ex);
        }
    }

    public boolean installPlugins(String sourcePath, String distPaht) {
        File sourceDir = new File(sourcePath);
        File distDir = new File(distPaht);
        if (sourceDir.exists()) {
            if (distDir.exists()) {
                movePlugins(sourceDir, distDir);
            } else {
                distDir.mkdir();
                movePlugins(sourceDir, distDir);
            }
        }
        return false;
    }

    /**
     *
     * @param path
     * @param classPath
     */
    public void loadPlugins(String path, String classPath) {
        File dir = new File(path);
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; i++) {
                try {
                    File file = files[i];
                    String fileName = file.getName();
                    if (fileName.substring(fileName.length() - 4, fileName.length()).equals(".jar")) {
                        PluginLoader loader = new PluginLoader(path + "/" + fileName, classPath + fileName.substring(0, fileName.length() - 4));
                        IPlugin plugin = loader.getPlugin();
                        PluginWrapper pluginWrapper = new PluginWrapper(plugin);
                        this.put(pluginWrapper.getName(), plugin);
                    }
                } catch (Exception e) {
                    LogWriter.error(getClass(), e);
                }
            }
        }
    }
}
