package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import javax.persistence.Transient;
import open.dolphin.log.LogWriter;
import open.dolphin.queries.DolphinQuery;
import org.hibernate.lob.BlobImpl;

/**
 * PublishedTreeModel generated by hbm2java
 */
public class PublishedTreeModel extends InfoModel implements IStampTreeModel {

    private long id;
    private UserModel user;
    private String name;
    private String publishType;
    private String category;
    private String partyName;
    private String url;
    private String description;
    private Date publishedDate;
    private Blob treeBlob;
    private byte[] treeBytes;
    private Date lastUpdated;
    @Transient
    private boolean imported;

    public PublishedTreeModel() {
    }

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    @Override
    public long getId() {
        return id;
    }

    /**
     *
     * @param id
     */
    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public UserModel getUser() {
        return user;
    }

    public void setUser(UserModel user) {
        this.user = user;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPublishType() {
        return publishType;
    }

    @Override
    public void setPublishType(String publishType) {
        this.publishType = publishType;
    }

    @Override
    public String getCategory() {
        return category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getPartyName() {
        return partyName;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }

    @Override
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    /**
     *
     * @return
     */
    @Override
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     *
     * @return
     */
    @Override
    public Date getPublishedDate() {
        return publishedDate;
    }

    @Override
    public void setPublishedDate(Date publishedDate) {
        this.publishedDate = publishedDate;
    }

    @Override
    public byte[] getTreeBytes() {
        return treeBytes;
    }

    /**
     *
     * @param treeBytes
     */
    public void setTreeBytes(byte[] treeBytes) {
        this.treeBytes = treeBytes;
        if (treeBytes == null) {
            this.treeBlob = null;
        } else {
            this.treeBlob = new BlobImpl(treeBytes);
        }
    }

    public Blob getTreeBlob() {
        return this.treeBlob;
    }

    public void setTreeBlob(Blob treeBlob) throws SQLException {
        if (treeBlob != null) {
            this.treeBlob = treeBlob;
            this.treeBytes = treeBlob.getBytes(1, (int) treeBlob.length());
        }
    }

    @Override
    public String getTreeXml() {
        if (treeBytes != null) {
            try {
                return new String(treeBytes, "UTF-8");
            } catch (UnsupportedEncodingException ex) {
                LogWriter.error(getClass(), ex);
            }
        }
        return "";
    }

    @Override
    public void setTreeXml(String treeXml) {
        if (treeXml != null) {
            try {
                treeBytes = treeXml.getBytes("UTF-8");
                if (treeBytes == null) {
                    treeBlob = null;
                } else {
                    treeBlob = new BlobImpl(treeBytes);
                }
            } catch (UnsupportedEncodingException ex) {
                LogWriter.error(getClass(), ex);
            }
        }
    }

    @Override
    public Date getLastUpdated() {
        return lastUpdated;
    }

    @Override
    public void setLastUpdated(Date updatedDate) {
        this.lastUpdated = updatedDate;
    }

    public boolean isImported() {
        return imported;
    }

    public void setImported(boolean imported) {
        this.imported = imported;
    }

    @Override
    public int hashCode() {
        final int PRIME = 31;
        int result = super.hashCode();
        result = PRIME * result + (int) (id ^ (id >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final PublishedTreeModel other = (PublishedTreeModel) obj;
        if (getId() != other.getId()) {
            return false;
        }
        return true;
    }
}
