package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import javax.persistence.Transient;
import open.dolphin.utils.CombinedStringParser;
import open.dolphin.utils.DiagnosisCode;

/**
 * RegisteredDiagnosisModel generated by hbm2java
 */
public class RegisteredDiagnosisModel extends KarteEntryBean {

    private String diagnosis;
    private String diagnosisCode;
    private String diagnosisCodeSystem;
    private String firstEncounterDate;
    private String relatedHealthInsurance;

    private DiagnosisCategoryModel diagnosisCategoryModel;
    private DiagnosisOutcomeModel diagnosisOutcomeModel;

    @Transient
    private PatientLiteModel patientLiteModel;
    @Transient
    private UserLiteModel userLiteModel;

    public RegisteredDiagnosisModel() {
    }

    public RegisteredDiagnosisModel(RegisteredDiagnosisModel original) {
        setDiagnosis(original.getDiagnosis());
        setDiagnosisCode(original.getDiagnosisCode());
        setDiagnosisCodeSystem(original.getDiagnosisCodeSystem());
    }

    public String getDiagnosis() {
        return this.diagnosis;
    }
    
    /**
     *
     * @param diagnosis
     */
    public void setDiagnosis(String diagnosis) {
        this.diagnosis = diagnosis;
    }

    public String getDiagnosisCode() {
        return this.diagnosisCode;
    }
    
    public void setDiagnosisCode(String diagnosisCode) {
        this.diagnosisCode = diagnosisCode;
    }

    public String getAlternateDiagnosisCode() {
        return new DiagnosisCode(diagnosisCode).getAlternateCode();
    }

    public String getDiagnosisCodeSystem() {
        return this.diagnosisCodeSystem;
    }
    
    public void setDiagnosisCodeSystem(String diagnosisCodeSystem) {
        this.diagnosisCodeSystem = diagnosisCodeSystem;
    }

    public String getCategory() {
        return diagnosisCategoryModel != null ? diagnosisCategoryModel.getDiagnosisCategory() : null;
    }

    public void setCategory(String category) {
        if (diagnosisCategoryModel == null) {
            diagnosisCategoryModel = new DiagnosisCategoryModel();
        }
        this.diagnosisCategoryModel.setDiagnosisCategory(category);
    }

    public String getCategoryDesc() {
        return diagnosisCategoryModel != null ? diagnosisCategoryModel.getDiagnosisCategoryDesc() : null;
    }

    public void setCategoryDesc(String categoryDesc) {
        if (diagnosisCategoryModel == null) {
            diagnosisCategoryModel = new DiagnosisCategoryModel();
        }
        this.diagnosisCategoryModel.setDiagnosisCategoryDesc(categoryDesc);
    }

    public String getCategoryCodeSys() {
        return diagnosisCategoryModel != null ? diagnosisCategoryModel.getDiagnosisCategoryCodeSys() : null;
    }

    public void setCategoryCodeSys(String categoryTable) {
        if (diagnosisCategoryModel == null) {
            diagnosisCategoryModel = new DiagnosisCategoryModel();
        }
        this.diagnosisCategoryModel.setDiagnosisCategoryCodeSys(categoryTable);
    }

    /**
     *
     * @return
     */
    public String getFirstEncounterDate() {
        return this.firstEncounterDate;
    }
    
    public void setFirstEncounterDate(String firstEncounterDate) {
        this.firstEncounterDate = firstEncounterDate;
    }

    public String getStartDate() {
        if (getStarted() != null) {
            return ModelUtils.getDateAsString(getStarted());
        }
        return null;
    }

    public void setStartDate(String startDate) {
        if (startDate != null) {
            int index = startDate.indexOf('T');
            if (index < 0) {
                startDate += "T00:00:00";
            }
            //System.out.println(startDate);
            setStarted(ModelUtils.getDateTimeAsObject(startDate));
        }
    }

    public String getEndDate() {
        if (getEnded() != null) {
            return ModelUtils.getDateAsString(getEnded());
        }
        return null;
    }

    public void setEndDate(String endDate) {
        if (endDate != null) {
            if (!endDate.isEmpty()) {
                int index = endDate.indexOf('T');
                if (index < 0) {
                    endDate += "T00:00:00";
                }
                setEnded(ModelUtils.getDateTimeAsObject(endDate));
            } else {
                setEnded(null);
            }
        }
    }

    public String getOutcome() {
        return diagnosisOutcomeModel != null ? diagnosisOutcomeModel.getOutcome() : null;
    }

    public void setOutcome(String outcome) {
        if (diagnosisOutcomeModel == null) {
            diagnosisOutcomeModel = new DiagnosisOutcomeModel();
        }
        this.diagnosisOutcomeModel.setOutcome(outcome);
    }

    public String getOutcomeDesc() {
        return diagnosisOutcomeModel != null ? diagnosisOutcomeModel.getOutcomeDesc() : null;
    }

    public void setOutcomeDesc(String outcomeDesc) {
        if (diagnosisOutcomeModel == null) {
            diagnosisOutcomeModel = new DiagnosisOutcomeModel();
        }
        this.diagnosisOutcomeModel.setOutcomeDesc(outcomeDesc);
    }

    public String getOutcomeCodeSys() {
        return diagnosisOutcomeModel != null ? diagnosisOutcomeModel.getOutcomeCodeSys() : null;
    }

    public void setOutcomeCodeSys(String outcomeTable) {
        if (diagnosisOutcomeModel == null) {
            diagnosisOutcomeModel = new DiagnosisOutcomeModel();
        }
        this.diagnosisOutcomeModel.setOutcomeCodeSys(outcomeTable);
    }

    /**
     *
     * @return
     */
    public String getRelatedHealthInsurance() {
        return this.relatedHealthInsurance;
    }
    
    /**
     *
     * @param relatedHealthInsurance
     */
    public void setRelatedHealthInsurance(String relatedHealthInsurance) {
        this.relatedHealthInsurance = relatedHealthInsurance;
    }

    public DiagnosisCategoryModel getDiagnosisCategoryModel() {
        return diagnosisCategoryModel;
    }

    public void setDiagnosisCategoryModel(
            DiagnosisCategoryModel diagnosisCategoryModel) {
        this.diagnosisCategoryModel = diagnosisCategoryModel;
    }

    public DiagnosisOutcomeModel getDiagnosisOutcomeModel() {
        return diagnosisOutcomeModel;
    }

    /**
     *
     * @param diagnosisOutcomeModel
     */
    public void setDiagnosisOutcomeModel(
            DiagnosisOutcomeModel diagnosisOutcomeModel) {
        this.diagnosisOutcomeModel = diagnosisOutcomeModel;
    }

    public PatientLiteModel getPatientLiteModel() {
        return patientLiteModel;
    }

    public void setPatientLiteModel(PatientLiteModel patientLiteModel) {
        this.patientLiteModel = patientLiteModel;
    }

    public UserLiteModel getUserLiteModel() {
        return userLiteModel;
    }

    public void setUserLiteModel(UserLiteModel userLiteModel) {
        this.userLiteModel = userLiteModel;
    }

    private static String[] splitDiagnosis(String diagnosis) {
        if (diagnosis == null) {
            return null;
        }
        String[] ret = null;
        try {
            ret = diagnosis.split("\\s*,\\s*");
        } catch (Exception e) {
           
        }
        return ret;
    }

    public String getDiagnosisName() {
        String[] splits = splitDiagnosis(this.diagnosis);
        return (splits != null && splits.length == 2 && splits[0] != null) ? splits[0] : this.diagnosis;
    }

    public String getAlternateDiagnosisName() {
        CombinedStringParser parser = new CombinedStringParser(getDiagnosisName());
        if (parser.size() > 1) {
            return parser.toPlainString();
        } else {
            return getDiagnosisName();
        }
    }

    public String getDiagnosisAlias() {
        String[] splits = splitDiagnosis(this.diagnosis);
        return (splits != null && splits.length == 2 && splits[1] != null) ? splits[1] : null;
    }

    public String getAliasOrName() {
        String[] aliasOrName = splitDiagnosis(this.diagnosis);
        if (aliasOrName != null && aliasOrName.length == 2 && aliasOrName[1] != null) {
            return aliasOrName[1];
        }
        return this.diagnosis;
    }

    public void clear() {
        setId(0L);
        setKarte(null);
        setCreator(null);
        setDiagnosisCategoryModel(null);
        setDiagnosisOutcomeModel(null);
        setFirstEncounterDate(null);
        setStartDate(null);
        setEndDate(null);
        setRelatedHealthInsurance(null);
        setFirstConfirmDate(null);
        setConfirmDate(null);
        setStatus(null);
        setPatientLiteModel(null);
        setUserLiteModel(null);
    }
}


