package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA


import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import open.dolphin.queries.DolphinQuery;

/**
 * UserModel generated by hbm2java
 */
public class UserModel extends InfoModel {

    private long id;

    private FacilityModel facility;
    private LicenseModel licenseModel;
    private DepartmentModel departmentModel;
    private Set<RoleModel> roles;

    private String userId;
    private String password;
    private String sirName;
    private String givenName;
    private String commonName;
    private String memberType;
    private String memo;
    private Date registeredDate;
    private String email;

    public UserModel() {
    }

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    /**
     *
     * @param facilityId
     * @param userId
     * @param SirName
     * @param GivenName
     * @param password
     */
    public void initialize(String facilityId, String userId, String SirName, String GivenName, String password) {
        StringBuilder sb = new StringBuilder(facilityId);
        sb.append(IInfoModel.COMPOSITE_KEY_MAKER);
        sb.append(userId.trim());
        setUserId(sb.toString());
        setPassword(password);
        setSirName(SirName.trim());
        setGivenName(GivenName.trim());
        setCommonName(getSirName() + " " + getGivenName());
    }

    /**
     *
     * @param userId
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return userId;
    }

    public String idAsLocal() {
        int index = userId.indexOf(COMPOSITE_KEY_MAKER);
        return userId.substring(index + 1);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /**
     *
     * @return
     */
    public String getPassword() {
        return password;
    }

    public void setSirName(String sirName) {
        this.sirName = sirName;
    }

    public String getSirName() {
        return sirName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    /**
     *
     * @return
     */
    public String getGivenName() {
        return givenName;
    }

    /**
     *
     * @param commonName
     */
    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getCommonName() {
        return commonName;
    }

    /**
     *
     * @param licenseValue
     */
    public void setLicenseModel(LicenseModel licenseValue) {
        this.licenseModel = licenseValue;
    }

    public LicenseModel getLicenseModel() {
        return licenseModel;
    }

    public void setFacility(FacilityModel facility) {
        this.facility = facility;
    }

    public FacilityModel getFacility() {
        return facility;
    }

    public void setDepartmentModel(DepartmentModel departmentValue) {
        this.departmentModel = departmentValue;
    }

    public DepartmentModel getDepartmentModel() {
        return departmentModel;
    }

    public void setRoles(Set<RoleModel> roles) {
        this.roles = roles;
    }

    public Set<RoleModel> getRoles() {
        return roles;
    }

    public void addRole(RoleModel value) {

        if (roles == null) {
            roles = new LinkedHashSet<RoleModel>(1);
        }
        roles.add(value);
    }

    public UserLiteModel getLiteModel() {

        UserLiteModel model = new UserLiteModel();
        model.setUserId(getUserId());
        model.setCommonName(getCommonName());
        LicenseModel lm = new LicenseModel();
        lm.setLicense(getLicenseModel().getLicense());
        lm.setLicenseDesc(getLicenseModel().getLicenseDesc());
        lm.setLicenseCodeSys(getLicenseModel().getLicenseCodeSys());
        model.setLicenseModel(lm);
        return model;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public String getMemberType() {
        return memberType;
    }

    /**
     *
     * @param memo
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getMemo() {
        return memo;
    }

    public void setRegisteredDate(Date registeredDate) {
        this.registeredDate = registeredDate;
    }

    public Date getRegisteredDate() {
        return registeredDate;
    }

    /**
     *
     * @param email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     *
     * @return
     */
    public String getEmail() {
        return email;
    }

    @Override
    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + (int) (id ^ (id >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final UserModel other = (UserModel) obj;
        if (getId() != other.getId()) {
            return false;
        }
        return true;
    }
}


