package open.dolphin.service;

import java.util.List;
import open.dolphin.dto.LaboSearchSpec;
import open.dolphin.infomodel.KarteBean;
import open.dolphin.infomodel.LaboModuleValue;
import open.dolphin.infomodel.PatientModel;
import org.hibernate.HibernateException;

/**
 * ILaboService
 *
 * @author Minagawa,Kazushi
 */
public interface ILaboService {
    
    /**
     * LaboModuleを保存する。
     * @param laboModuleValue LaboModuleValue
     */
    public PatientModel putLaboModule(LaboModuleValue laboModuleValue);
    
    public KarteBean getKarteFor(String patientId) throws HibernateException;

    public List<LaboModuleValue> getModulesFor(long karteId);
}
