/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package open.dolphin.utils;

import open.dolphin.project.GlobalVariables;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;

/**
 * Hibernate Utility class with a convenient method to get Session Factory object.
 *
 * @author tomohiro
 */
public class HibernateUtil {

    private static Configuration config;
    private static SessionFactory sessionFactory;
    private static String currentDbAddress;
    private static String currentDbPassword;
    private static boolean currentDbSSLState;

    private static void createSessionFactory() {
        try {
            currentDbAddress  = GlobalVariables.getDbAddress();
            currentDbPassword = GlobalVariables.getDbPasswordWithoutHash();
            currentDbSSLState = GlobalVariables.getDbSSLState();
            String dbAddress = "jdbc:postgresql://" + currentDbAddress + ":5432/dolphin";
            if (currentDbSSLState) {
                dbAddress += "?ssl";
            }
            config = new Configuration()
                    .setProperty("hibernate.connection.url", dbAddress)
                    .setProperty("hibernate.connection.password", currentDbPassword);
            sessionFactory = config.configure().buildSessionFactory();
        } catch (Throwable ex) {
            System.err.println("Initial SessionFactory creation failed." + ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static void createSchema() {
        if (config == null) {
            createSessionFactory();
        }
        (new SchemaExport(config)).create(false, true);
    }

    public static SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            createSessionFactory();
        }
        return sessionFactory;
    }

    /**
     *
     * @return
     */
    public static Session openSession() {
        if (isStatusChange()) {
            createSessionFactory();
        }
        return getSessionFactory().openSession();
    }

    /**
     *
     * @param session
     */
    public static void closeSession(Session session) {
        if (session == null || !session.isOpen()) {
            return;
        }
        session.close();
    }

    private static boolean isStatusChange() {
        return    !GlobalVariables.getDbAddress().equals(currentDbAddress) ||
                  !GlobalVariables.getDbPasswordWithoutHash().equals(currentDbPassword) ||
                  !(GlobalVariables.getDbSSLState() == currentDbSSLState);
    }
}
