// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2012 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/atb_gauge.hpp"
#include "graphics/drawable.hpp"
#include "graphics/image.hpp"
#include "common/util.hpp"
#include "graphics/image_lookup.hpp"
#include "DxLib.h"

atb_gauge::atb_gauge()
	: drawable(),
	  active( true ),
	  value( 0 ),
	  gauge_image( nullptr ),
	  position( -1, -1 )
{
	this->gauge_image = image_lookup::instance()->get_image( image_lookup::atb_gauge );
}

atb_gauge::atb_gauge( point position )
	: drawable(),
	  active( true ),
	  value( 0 ),
	  gauge_image( nullptr ),
	  position( position )
{
	this->gauge_image = image_lookup::instance()->get_image( image_lookup::atb_gauge );
}

atb_gauge::~atb_gauge()
{
}

void atb_gauge::init()
{
	this->active = true;
	this->value  = 0   ;
}

void atb_gauge::init( point position )
{
	this->active   = true    ;
	this->value    = 0       ;
	this->position = position;
}

void atb_gauge::draw()
{
	int x = this->position.x + 5;
	int y = this->position.y + 2;
	int progress = this->value * 52 / this->max_value;

	int bg_color = 0;
	int fg_color = 0;
	if ( this->value != this->max_value )
	{
		bg_color = DxLib::GetColor( 210, 210, 210 );
		fg_color = DxLib::GetColor( 255, 255, 255 );
	}
	else
	{
		bg_color = DxLib::GetColor( 255, 180,  60 );
		fg_color = DxLib::GetColor( 255, 220, 100 );
	}
	DxLib::DrawBox( x, y + 1, x + progress, y + 3, bg_color, TRUE );
	DxLib::DrawBox( x, y + 1, x + progress, y + 2, fg_color, TRUE );

	this->gauge_image->draw( this->position, true );
}

void atb_gauge::increase_value_bounded( int delta )
{
	this->value += delta;

	if ( this->value < this->min_value )
	{
		this->value = this->min_value;
	}
	else if ( this->value > this->max_value )
	{
		this->value = this->max_value;
	}
}

void atb_gauge::increase_value_bounded_above( int delta )
{
	this->value += delta;

	if ( this->value > this->max_value )
	{
		this->value = this->max_value;
	}
}

void atb_gauge::decrease_value_bounded_below( int delta )
{
	this->value -= delta;

	if ( this->value < this->min_value )
	{
		this->value = this->min_value;
	}
}
