// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2012 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef ATB_GAUGE_HPP
#define ATB_GAUGE_HPP

#include "graphics/drawable.hpp"
#include "common/util.hpp"
class image;

class atb_gauge : public drawable
{
public:
	enum : int
	{
		max_value = 1000,
		min_value =    0,
	};

	atb_gauge();
	atb_gauge( point position );
	virtual ~atb_gauge();

	void init();
	void init( point position );

	virtual void draw();

	void increase_value_bounded      ( int delta );
	void increase_value_bounded_above( int delta );
	void decrease_value_bounded_below( int delta );

	bool is_maximum() { return this->value == max_value; }

	bool  is_active()    { return this->active  ; }
	int   get_value()    { return this->value   ; }
	point get_position() { return this->position; }

	void set_active  ( bool  active   ) { this->active   = active  ; }
	void set_value   ( int   value    ) { this->value    = value   ; }
	void set_position( point position ) { this->position = position; }

private:
	bool active;

	int value;

	image* gauge_image;
	point  position;
};

#endif // ATB_GAUGE_HPP
