// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2012-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef BATTLE_CONTEXT_HPP
#define BATTLE_CONTEXT_HPP

#include "battle/hero_party_btl.hpp"
#include "battle/enemy_party_btl.hpp"
#include "battle/layered_updater_btl.hpp"
#include "battle/layered_drawer_btl.hpp"
#include "battle/atb_scheduler.hpp"
#include "battle/command_publisher.hpp"
#include "battle/battle_event_manager.hpp"
#include "common/general_queue.hpp"
class hero_btl;
class enemy_btl;
class battle_event;
#include "battle/hero_party_window.hpp"
#include "battle/enemy_party_window.hpp"
#include "battle/message_window.hpp"
#include "battle/command_window.hpp"
#include "battle/background_drawer.hpp"

class battle_context
{
public:
	battle_context();
	battle_context( hero_party_btl* hero_party, enemy_party_btl* enemy_party );
	virtual ~battle_context();

	void init( hero_party_btl* hero_party, enemy_party_btl* enemy_party );

	layered_updater_btl* get_updater() { return &( this->updater ); }
	layered_drawer_btl*  get_drawer () { return &( this->drawer  ); }

	atb_scheduler*        get_scheduler    () { return &( this->scheduler     ); }
	command_publisher*    get_commander    () { return &( this->commander     ); }
	battle_event_manager* get_event_manager() { return &( this->event_manager ); }

	general_queue< hero_btl*     >* get_hero_ready_queue () { return &( this->hero_ready_queue  ); }
	general_queue< enemy_btl*    >* get_enemy_ready_queue() { return &( this->enemy_ready_queue ); }
	general_queue< battle_event* >* get_event_queue      () { return &( this->event_queue       ); }

	hero_party_btl*  get_hero_party () { return &( this->hero_party  ); }
	enemy_party_btl* get_enemy_party() { return &( this->enemy_party ); }

	hero_party_window*  get_hero_window () { return &( this->hero_window  ); }
	enemy_party_window* get_enemy_window() { return &( this->enemy_window ); }
	message_window*     get_msg_window  () { return &( this->msg_window   ); }
	command_window*     get_cmd_window  () { return &( this->cmd_window   ); }

	background_drawer* get_bg_drawer() { return &( this->bg_drawer ); }

	void set_updater( layered_updater_btl* updater ) { this->updater = *updater; }
	void set_drawer ( layered_drawer_btl*  drawer  ) { this->drawer  = *drawer ; }

	void set_scheduler    ( atb_scheduler*        scheduler     ) { this->scheduler     = *scheduler    ; }
	void set_commander    ( command_publisher*    commander     ) { this->commander     = *commander    ; }
	void set_event_manager( battle_event_manager* event_manager ) { this->event_manager = *event_manager; }

	void set_hero_ready_queue ( general_queue< hero_btl*     >* hero_ready_queue  ) { this->hero_ready_queue  = *hero_ready_queue ; }
	void set_enemy_ready_queue( general_queue< enemy_btl*    >* enemy_ready_queue ) { this->enemy_ready_queue = *enemy_ready_queue; }
	void set_event_queue      ( general_queue< battle_event* >* event_queue       ) { this->event_queue       = *event_queue      ; }

	void set_hero_party ( hero_party_btl*  hero_party  ) { this->hero_party  = *hero_party ; }
	void set_enemy_party( enemy_party_btl* enemy_party ) { this->enemy_party = *enemy_party; }

	void set_hero_window ( hero_party_window*  hero_window  ) { this->hero_window  = *hero_window ; }
	void set_enemy_window( enemy_party_window* enemy_window ) { this->enemy_window = *enemy_window; }
	void set_msg_window  ( message_window*     msg_window   ) { this->msg_window   = *msg_window  ; }
	void set_cmd_window  ( command_window*     cmd_window   ) { this->cmd_window   = *cmd_window  ; }

	void set_bg_drawer( background_drawer* bg_drawer ) { this->bg_drawer = *bg_drawer; }

private:
	// level 0
	layered_updater_btl updater;
	layered_drawer_btl  drawer ;

	// level 1
	atb_scheduler        scheduler;
	command_publisher    commander;
	battle_event_manager event_manager;

	// level 2
	general_queue< hero_btl*     > hero_ready_queue ;
	general_queue< enemy_btl*    > enemy_ready_queue;
	general_queue< battle_event* > event_queue      ;

	// level 3
	hero_party_btl  hero_party ;
	enemy_party_btl enemy_party;

	hero_party_window  hero_window ;
	enemy_party_window enemy_window;
	message_window     msg_window;
	command_window     cmd_window;

	background_drawer bg_drawer;
};

#endif // BATTLE_CONTEXT_HPP
