// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef BATTLE_EVENT_MANAGER_HPP
#define BATTLE_EVENT_MANAGER_HPP

#include "common/updatable.hpp"
#include "common/general_queue.hpp"
class battle_event;
class layered_updater_btl;
class layered_drawer_btl;

class battle_event_manager : public updatable
{
public:
	battle_event_manager();
	virtual ~battle_event_manager();

	void init( general_queue< battle_event* >* event_queue,
	           layered_updater_btl* updater,
	           layered_drawer_btl*  drawer );

	virtual bool update();

private:
	general_queue< battle_event* >* event_queue;

	layered_updater_btl* updater;
	layered_drawer_btl*  drawer ;
};

#endif // BATTLE_EVENT_MANAGER_HPP
