// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/battle_joiner.hpp"
#include "common/character_id.hpp"
#include "common/character_status.hpp"
#include "battle/character_graphic_btl.hpp"
#include "battle/atb_gauge.hpp"

battle_joiner::battle_joiner( character_status* status, character_status* init_status )
	: id(),
	  status( status ),
	  init_status( init_status ),
	  graphic(),
	  gauge()
{
}

battle_joiner::battle_joiner( character_id* id, character_status* status, character_status* init_status, character_graphic_btl* graphic, atb_gauge* gauge )
	: id( *id ),
	  status( status ),
	  init_status( init_status ),
	  graphic( *graphic ),
	  gauge( *gauge )
{
}

battle_joiner::~battle_joiner()
{
}

bool battle_joiner::update()
{
	return true;
}
