// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/battle_object_factory.hpp"
#include "battle/hero_btl.hpp"
#include "common/hero_status.hpp"
#include "battle/enemy_btl.hpp"
#include "battle/enemy_status.hpp"
#include "battle/hero_party_btl.hpp"
#include "battle/enemy_party_btl.hpp"
#include <memory>
#include <cassert>

battle_object_factory* battle_object_factory::instance()
{
	static battle_object_factory _instance;
	return &_instance;
}

hero_btl* battle_object_factory::get_hero()
{
	hero_status* status      = new hero_status();
	hero_status* init_status = new hero_status();

	hero_btl* hero = new hero_btl( status, init_status );
	this->register_hero( hero );

	return hero;
}

enemy_btl* battle_object_factory::get_enemy()
{
	enemy_status* status      = new enemy_status();
	enemy_status* init_status = new enemy_status();

	enemy_btl* enemy = new enemy_btl( status, init_status );
	this->register_enemy( enemy );

	return enemy;
}

hero_party_btl* battle_object_factory::get_hero_party()
{
	hero_party_btl* hero_party = new hero_party_btl();
	this->register_hero_party( hero_party );

	return hero_party;
}

enemy_party_btl* battle_object_factory::get_enemy_party()
{
	enemy_party_btl* enemy_party = new enemy_party_btl();
	this->register_enemy_party( enemy_party );

	return enemy_party;
}

void battle_object_factory::register_hero( hero_btl* hero )
{
	for ( int i = 0 ; i < this->capacity ; ++i )
	{
		if ( this->hero_a[ i ] == nullptr )
		{
			this->hero_a[ i ].reset( hero );
			return;
		}
	}
	assert( 0 );
}

void battle_object_factory::register_enemy( enemy_btl* enemy )
{
	for ( int i = 0 ; i < this->capacity ; ++i )
	{
		if ( this->enemy_a[ i ] == nullptr )
		{
			this->enemy_a[ i ].reset( enemy );
			return;
		}
	}
	assert( 0 );
}

void battle_object_factory::register_hero_party( hero_party_btl* hero_party )
{
	for ( int i = 0 ; i < this->capacity / 2 ; ++i )
	{
		if ( this->hero_party_a[ i ] == nullptr )
		{
			this->hero_party_a[ i ].reset( hero_party );
			return;
		}
	}
	assert( 0 );
}

void battle_object_factory::register_enemy_party( enemy_party_btl* enemy_party )
{
	for ( int i = 0 ; i < this->capacity / 2 ; ++i )
	{
		if ( this->enemy_party_a[ i ] == nullptr )
		{
			this->enemy_party_a[ i ].reset( enemy_party );
			return;
		}
	}
	assert( 0 );
}

battle_object_factory::battle_object_factory()
{
}

battle_object_factory::~battle_object_factory()
{
}
