// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef ENEMY_PARTY_WINDOW_HPP
#define ENEMY_PARTY_WINDOW_HPP

#include "graphics/drawable.hpp"
#include "common/util.hpp"
class enemy_party_btl;
class enemy_btl;
#include "graphics/framed_window.hpp"

class enemy_party_window : public drawable
{
public:
	enemy_party_window( rectangle r );
	virtual ~enemy_party_window();

	void init( enemy_party_btl* enemy_party );

	virtual void draw();

	void load_image();

private:
	enum { n_enemy = 8 };

	enemy_party_btl* enemy_party;
	enemy_btl* enemy[ n_enemy ];

	framed_window frame;
	point frame_position;

	const char* name[ n_enemy ];
	point name_position[ n_enemy ];

	int count[ n_enemy ];
	point count_position[ n_enemy ];

	image image_cache;
};

#endif // ENEMY_PARTY_WINDOW_HPP
