// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2012-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/layered_drawer_btl.hpp"
#include "graphics/drawable.hpp"
#include <cassert>

layered_drawer_btl::layered_drawer_btl()
{
	this->layers[ this->bottommost   ] = &( this->bottommost_   );
	this->layers[ this->background   ] = &( this->background_   );
	this->layers[ this->bottom       ] = &( this->bottom_       );

	this->layers[ this->enemy        ] = &( this->enemy_        );
	this->layers[ this->enemy_effect ] = &( this->enemy_effect_ );
	this->layers[ this->middle       ] = &( this->middle_       );
	this->layers[ this->hero         ] = &( this->hero_         );
	this->layers[ this->hero_effect  ] = &( this->hero_effect_  );

	this->layers[ this->top          ] = &( this->top_          );
	this->layers[ this->window_5     ] = &( this->window_5_     );
	this->layers[ this->window_4     ] = &( this->window_4_     );
	this->layers[ this->window_3     ] = &( this->window_3_     );
	this->layers[ this->window_2     ] = &( this->window_2_     );
	this->layers[ this->window_1     ] = &( this->window_1_     );
	this->layers[ this->topmost      ] = &( this->topmost_      );

	this->clear();
}

layered_drawer_btl::~layered_drawer_btl()
{
}

void layered_drawer_btl::clear()
{
	drawable* ( *layer )[ capacity ] = nullptr;

	for ( int i = 0 ; i < this->sizeof_layer_t ; ++i )
	{
		layer = this->layers[ i ];

		for ( int j = 0 ; j < this->capacity ; ++j )
		{
			( *layer )[ j ] = nullptr;
		}

		this->layer_enabled[ i ] = true;
	}
}

void layered_drawer_btl::draw()
{
	drawable* ( *layer )[ capacity ] = nullptr;

	for ( int i = 0 ; i < this->sizeof_layer_t ; ++i )
	{
		if ( this->layer_enabled[ i ] == false )
		{
			continue;
		}

		layer = this->layers[ i ];

		for ( int j = 0 ; j < this->capacity ; ++j )
		{
			if ( ( *layer )[ j ] != nullptr )
			{
				( *layer )[ j ]->draw();
			}
		}
	}
}

void layered_drawer_btl::add_to_layer( layer_t l, drawable* d )
{
	drawable* ( *layer )[ capacity ] = this->layers[ l ];

	for ( int i = 0 ; i < this->capacity ; ++i )
	{
		if ( ( *layer )[ i ] == nullptr )
		{
			( *layer )[ i ] = d;
			return;
		}
	}
	assert( 0 );
}

void layered_drawer_btl::remove_from_layer( layer_t l, drawable* d )
{
	drawable* ( *layer )[ capacity ] = this->layers[ l ];

	for ( int i = 0 ; i < this->capacity ; ++i )
	{
		if ( ( *layer )[ i ] == d )
		{
			( *layer )[ i ] = nullptr;
		}
	}
}
