// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/message_window.hpp"
#include "common/util.hpp"
#include "graphics/drawable.hpp"
#include "graphics/framed_window.hpp"
#include "DxLib.h"

message_window::message_window( rectangle r )
	: drawable(),
	  frame( r ),
	  frame_position( r.x, r.y ),
	  message( nullptr ),
	  message_offset( 9, 8 ),
	  image_cache()
{
	this->message = "قق";
	this->load_image();
}

message_window::~message_window()
{
}

void message_window::draw()
{
	int x = this->frame_position.x;
	int y = this->frame_position.y;

	this->image_cache.draw( point( x, y ), false );
}

void message_window::load_image()
{
	rectangle r = this->frame.get_rectangle();

	int ww = r.w;
	int wh = r.h;

	// canvas ɕ`悷
	int canvas = DxLib::MakeScreen( ww, wh, FALSE );
	DxLib::SetDrawScreen( canvas );

	// `e
	this->frame.draw_();

	if ( this->message != nullptr )
	{
		int x = this->frame_position.x + this->message_offset.x;
		int y = this->frame_position.y + this->message_offset.y;
		int color = DxLib::GetColor( 255, 255, 255 );

		DxLib::SetFontSize( 16 );
		DxLib::DrawString( x,  y, this->message, color );
		DxLib::SetFontSize( 10 );
	}

	// `ɖ߂
	DxLib::SetDrawScreen( DX_SCREEN_BACK );

	// ̎Ή
	int handle = this->image_cache.get_handle();
	if ( handle != -1 )
	{
		DxLib::DeleteGraph( handle );
	}

	this->image_cache = image( canvas, ww, wh );
}
