// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "common/character_status.hpp"
#include <cstdint>

character_status::character_status()
	: level( -1 ),
	  current_hp( -1 ),
	  maximum_hp( -1 ),
	  current_mp( -1 ),
	  maximum_mp( -1 ),
	  perm_status( 0U ),
	  temp_status( 0U ),
	  position( character_status::unknown ),
	  strength( -1 ),
	  speed( -1 ),
	  stamina( -1 ),
	  magic( -1 ),
	  attack( -1 ),
	  defense( -1 ),
	  evasion( -1 ),
	  magic_defense( -1 ),
	  magic_evasion( -1 ),
	  ordering( -1 )
{
}

character_status::~character_status()
{
}

void character_status::init_a( int level, int current_hp, int maximum_hp, int current_mp, int maximum_mp,
                               std::uint32_t perm_status, std::uint32_t temp_status, battle_position position )
{
	this->level       = level      ;
	this->current_hp  = current_hp ;
	this->maximum_hp  = maximum_hp ;
	this->current_mp  = current_mp ;
	this->maximum_mp  = maximum_mp ;
	this->perm_status = perm_status;
	this->temp_status = temp_status;
	this->position    = position   ;
}

void character_status::init_b( int strength, int speed, int stamina, int magic, int attack,
                               int defense, int evasion, int magic_defense, int magic_evasion )
{
	this->strength      = strength     ;
	this->speed         = speed        ;
	this->stamina       = stamina      ;
	this->magic         = magic        ;
	this->attack        = attack       ;
	this->defense       = defense      ;
	this->evasion       = evasion      ;
	this->magic_defense = magic_defense;
	this->magic_evasion = magic_evasion;
}

void character_status::init_c( int ordering )
{
	this->ordering = ordering;
}

void character_status::increase_hp_bounded( int delta )
{
	this->current_hp += delta;

	if ( this->current_hp < 0 )
	{
		this->current_hp = 0;
	}
	else if ( this->current_hp > this->maximum_hp )
	{
		this->current_hp = this->maximum_hp;
	}
}

void character_status::increase_mp_bounded( int delta )
{
	this->current_mp += delta;

	if ( this->current_mp < 0 )
	{
		this->current_mp = 0;
	}
	else if ( this->current_mp > this->maximum_mp )
	{
		this->current_mp = this->maximum_mp;
	}
}

void character_status::increase_hp_bounded_above( int delta )
{
	this->current_hp += delta;

	if ( this->current_hp > this->maximum_hp )
	{
		this->current_hp = this->maximum_hp;
	}
}

void character_status::increase_mp_bounded_above( int delta )
{
	this->current_mp += delta;

	if ( this->current_mp > this->maximum_mp )
	{
		this->current_mp = this->maximum_mp;
	}
}

void character_status::decrease_hp_bounded_below( int delta )
{
	this->current_hp -= delta;

	if ( this->current_hp < 0 )
	{
		this->current_hp = 0;
	}
}

void character_status::decrease_mp_bounded_below( int delta )
{
	this->current_mp -= delta;

	if ( this->current_mp < 0 )
	{
		this->current_mp = 0;
	}
}

bool character_status::is_dead()
{
	return ( ( this->perm_status & this->dead ) != 0U );
}

bool character_status::is_zombie()
{
	return ( ( this->perm_status & this->zombie ) != 0U );
}

bool character_status::is_poison()
{
	return ( ( this->temp_status & this->poison ) != 0U );
}

bool character_status::is_confuse()
{
	return ( ( this->temp_status & this->confuse ) != 0U );
}

bool character_status::permanent_status_enabled( std::uint32_t mask )
{
	return ( ( this->perm_status & mask ) == mask );
}

bool character_status::temporary_status_enabled( std::uint32_t mask )
{
	return ( ( this->temp_status & mask ) == mask );
}

bool character_status::status_enabled( std::uint32_t mask )
{
	std::uint32_t status = this->perm_status | this->temp_status;
	return ( ( status & mask ) == mask );
}
