// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "graphics/framed_window.hpp"
#include "common/util.hpp"
#include "graphics/image.hpp"
#include "DxLib.h"
#include "graphics/image_lookup.hpp"
#include "graphics/sprite.hpp"

framed_window::framed_window( rectangle r )
	: r( r ),
	  window_image()
{
	this->load_window_image();
}

framed_window::~framed_window()
{
}

void framed_window::draw()
{
	this->window_image.draw( point( this->r.x, this->r.y ), false );
}

void framed_window::draw_()
{
	this->window_image.draw( point( 0, 0 ), false );
}

void framed_window::set_rectangle( rectangle r )
{
	this->r = r;
	this->load_window_image();
}

void framed_window::load_window_image()
{
	int ww = this->r.w;
	int wh = this->r.h;

	// canvas ɕ`悷
	int canvas = DxLib::MakeScreen( ww, wh, FALSE );
	DxLib::SetDrawScreen( canvas );

	image_lookup* il = image_lookup::instance();

	// ܂Awih
	image* background = il->get_image( image_lookup::window_background );
	background->draw( point( 0, 0 ), false );

	// ɁAg`悷
	sprite* frame_chip = il->get_sprite( image_lookup::window_frame );
	int cw = frame_chip->get_chip_w();
	int ch = frame_chip->get_chip_h();

	// l̘g
	frame_chip->draw( 0, point( 0,       0       ), true );
	frame_chip->draw( 1, point( ww - cw, 0       ), true );
	frame_chip->draw( 2, point( 0,       wh - ch ), true );
	frame_chip->draw( 3, point( ww - cw, wh - ch ), true );

	// ㉺̘g
	int x_chips = ww / cw - 2;
	int x_offset = ww % cw;

	// EBhE̕`bv摜̕ŊƁA]肪oꍇ
	int x = 0;
	if ( x_offset != 0 && x_chips > 0 )
	{
		frame_chip->draw( 4, point( cw,      0       ), true );
		frame_chip->draw( 5, point( cw,      wh - ch ), true );
	}
	else if ( x_offset != 0 && x_chips == 0 )
	{
		x = ( ww - cw ) / 2;
		frame_chip->draw( 4, point( x,       0       ), true );
		frame_chip->draw( 5, point( x,       wh - ch ), true );
	}

	for ( int x_chip = 0 ; x_chip < x_chips ; x_chip++ )
	{
		x = ( cw + x_offset ) + cw * x_chip;
		frame_chip->draw( 4, point( x,       0       ), true );
		frame_chip->draw( 5, point( x,       wh - ch ), true );
	}

	// E̘g
	int y_chips = wh / ch - 2;
	int y_offset = wh % ch;

	// EBhE̍`bv摜̍ŊƁA]肪oꍇ
	int y = 0;
	if ( y_offset != 0 && y_chips > 0 )
	{
		frame_chip->draw( 6, point( 0,       ch      ), true );
		frame_chip->draw( 7, point( ww - cw, ch      ), true );
	}
	else if ( y_offset != 0 && y_chips == 0 )
	{
		y = ( wh - ch ) / 2;
		frame_chip->draw( 6, point( 0,       y       ), true );
		frame_chip->draw( 7, point( ww - cw, y       ), true );
	}

	for ( int y_chip = 0 ; y_chip < y_chips ; y_chip++ )
	{
		y = ( ch + y_offset ) + ch * y_chip;
		frame_chip->draw( 6, point( 0,       y       ), true );
		frame_chip->draw( 7, point( ww - cw, y       ), true );
	}

	// `ɖ߂
	DxLib::SetDrawScreen( DX_SCREEN_BACK );

	// ̎Ή
	int handle = this->window_image.get_handle();
	if ( handle != -1 )
	{
		DxLib::DeleteGraph( handle );
	}

	this->window_image = image( canvas, ww, wh );
}
