// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef SPRITE_HPP
#define SPRITE_HPP

class point;
class image;

class sprite
{
public:
	sprite();
	sprite( int* handle, int n_chips, int x_chips, int y_chips, int chip_w, int chip_h );
	virtual ~sprite();

	void init( int* handle, int n_chips, int x_chips, int y_chips, int chip_w, int chip_h );

	// index  DxLib::LoadDivGraph() Ԃz̓Y
	void draw( int index,              point p, bool trans_flag );
	void draw( int x_chip, int y_chip, point p, bool trans_flag );

	void recycle_image( image* i, int index              );
	void recycle_image( image* i, int x_chip, int y_chip );

	image get_image( int index              );
	image get_image( int x_chip, int y_chip );

	int* get_handle () { return this->handle ; }
	int  get_n_chips() { return this->n_chips; }
	int  get_x_chips() { return this->x_chips; }
	int  get_y_chips() { return this->y_chips; }
	int  get_chip_w () { return this->chip_w ; }
	int  get_chip_h () { return this->chip_h ; }

	void set_handle ( int* handle  ) { this->handle  = handle ; }
	void set_n_chips( int  n_chips ) { this->n_chips = n_chips; }
	void set_x_chips( int  x_chips ) { this->x_chips = x_chips; }
	void set_y_chips( int  y_chips ) { this->y_chips = y_chips; }
	void set_chip_w ( int  chip_w  ) { this->chip_w  = chip_w ; }
	void set_chip_h ( int  chip_h  ) { this->chip_h  = chip_h ; }

private:
	int* handle ;
	int  n_chips;
	int  x_chips;
	int  y_chips;
	int  chip_w ;
	int  chip_h ;
};

#endif // SPRITE_HPP
