// -*- coding: sjis; tab-width: 4; -*-

#include <iostream>

#include <ft2build.h>
#include FT_FREETYPE_H

int main()
{
	//const char* filename = "mplus-1m-thin.ttf";
	//const char* filename = "mplus_j12r.pcf";
	const char* filename = "unifont.pcf";

	FT_Error error;

	FT_Library library;
	error = FT_Init_FreeType( &library );
	if ( error )
		std::cout << "Error: FT_Init_FreeType()" << std::endl;

	FT_Face face;
	error = FT_New_Face( library, filename, 0, &face );
	if ( error )
		std::cout << "Error: FT_New_Face()" << std::endl;

	/*
	std::cout << "family_name:  " << face->family_name  << std::endl;
	std::cout << "style_name:   " << face->style_name   << std::endl;
	*/
	std::cout << "num_charmaps: " << face->num_charmaps << std::endl;

	std::cout << "encoding:     " << face->charmaps[0]->encoding    << std::endl;
	std::cout << "platform_id:  " << face->charmaps[0]->platform_id << std::endl;
	std::cout << "encoding_id:  " << face->charmaps[0]->encoding_id << std::endl;

	std::ios_base::fmtflags saveflags = std::cout.setf( std::ios_base::hex | std::ios_base::showbase );
	std::cout.unsetf( std::ios_base::dec );
	std::cout << "charmap:      " << (long)face->charmap << std::endl;
	std::cout.flags( saveflags );

	error = FT_Set_Pixel_Sizes( face, 8, 16 );
	if ( error )
		std::cout << "Error: FT_Set_Pixel_Sizes()" << std::endl;

	//error = FT_Load_Char( face, 0x3042, FT_LOAD_RENDER | FT_LOAD_MONOCHROME );
	//error = FT_Load_Char( face, 0x3042, FT_LOAD_DEFAULT );
	if ( error )
		std::cout << "Error: FT_Load_Char()" << std::endl;

	FT_UInt glyph_index = FT_Get_Char_Index( face, 0x3042 );

	saveflags = std::cout.setf( std::ios_base::hex | std::ios_base::showbase );
	std::cout.unsetf( std::ios_base::dec );
	std::cout << "glyph_index:  " << glyph_index << std::endl;
	std::cout.flags( saveflags );

	error = FT_Load_Glyph( face, glyph_index, FT_LOAD_DEFAULT );
	if ( error )
		std::cout << "Error: FT_Render_Glyph()" << std::endl;

	switch ( face->glyph->format )
	{
		case FT_GLYPH_FORMAT_BITMAP:
			std::cout << "FT_GLYPH_FORMAT_BITMAP" << std::endl;
			break;
		case FT_GLYPH_FORMAT_OUTLINE:
			std::cout << "FT_GLYPH_FORMAT_OUTLINE" << std::endl;
			break;
	}

	if ( face->glyph->format != FT_GLYPH_FORMAT_BITMAP )
	{
		error = FT_Render_Glyph( face->glyph, FT_RENDER_MODE_MONO );
		if ( error )
			std::cout << "Error: FT_Render_Glyph()" << std::endl;
	}

	FT_Bitmap* bm = &( face->glyph->bitmap );

	std::cout << "bm->rows:     " << bm->rows  << std::endl;
	std::cout << "bm->pitch:    " << bm->pitch << std::endl;
	std::cout << "0         1         2         3         4         5         6         7         8         9         " << std::endl;
	std::cout << "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890" << std::endl;

	unsigned char c;
	for ( int row = 0 ; row < bm->rows ; row++ )
	{
		for ( int col = 0 ; col < bm->pitch ; col++ )
		{
			c = bm->buffer[ bm->pitch * row + col ];
			//std::cout << (unsigned int)c;
			for ( int bit = 7 ; bit >= 0 ; bit-- )
			{
				if ( ( ( c >> bit ) & 1 ) == 0 )
					std::cout << "__";
				else
					std::cout << "##";
			}
		}
		std::cout << std::endl;
	}

	error = FT_Done_FreeType( library );
	if ( error )
		std::cout << "Error: FT_Done_FreeType()" << std::endl;

	return 0;
}
