// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef INPUT_HANDLER_HPP
#define INPUT_HANDLER_HPP

#include <cstdint>

class input_handler
{
public:
	enum input_mask : std::uint32_t
	{
		AXIS_UP       = 1U <<  0,
		AXIS_DOWN     = 1U <<  1,
		AXIS_LEFT     = 1U <<  2,
		AXIS_RIGHT    = 1U <<  3,
		BUTTON_A      = 1U <<  4,
		BUTTON_B      = 1U <<  5,
		BUTTON_X      = 1U <<  6,
		BUTTON_Y      = 1U <<  7,
		BUTTON_L      = 1U <<  8,
		BUTTON_R      = 1U <<  9,
		BUTTON_START  = 1U << 10,
		BUTTON_SELECT = 1U << 11,
		INITIAL_MASK  = 0xFFFFFFFFU
	};

	input_handler();
	virtual ~input_handler();

	virtual bool poll_input() = 0;
	bool is_pressed( input_mask mask );

protected:
	std::uint32_t current_mask;

	// ˑ̓͏Ԃ current_mask \
	virtual void interpret_input() = 0;
};

#endif // INPUT_HANDLER_HPP
