// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "system_base/sequence_manager.hpp"
class sequence;
class controller;
#include <cassert>

sequence_manager* sequence_manager::instance( sequence* sa[], controller* ca[] )
{
	static sequence_manager _instance( sa, ca );
	return &_instance;
}

void sequence_manager::switch_sequence( sequence_t next )
{
	this->s_current = this->sa[ next ];
	this->c_current = this->ca[ next ];
}

sequence_manager::sequence_manager( sequence* sa[], controller* ca[] )
	: s_current( nullptr ),
	  c_current( nullptr )
{
	assert( sa != nullptr );
	assert( ca != nullptr );

	for ( int i = 0 ; i < this->sizeof_sequence_t ; ++i )
	{
		this->sa[ i ] = sa[ i ];
		this->ca[ i ] = ca[ i ];
	}

	// ÑftHgV[PX
	this->s_current = sa[ this->battle ];
	this->c_current = ca[ this->battle ];
}

sequence_manager::~sequence_manager()
{
}
