// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "system_top/system_builder.hpp"
#include "system_top/main_loop.hpp"
#include "system_base/win32_driver.hpp"
#include "system_base/dxlib_driver.hpp"
#include "graphics/image_lookup.hpp"

// --------------------------------------------------

class sequence;
#include "system_base/sequence_manager.hpp"
#include "battle/battle_sequence.hpp"

// --------------------------------------------------

class controller;
#include "battle/battle_controller.hpp"

// --------------------------------------------------

#include "system_base/input_handler_dxlib.hpp"

system_builder* system_builder::instance()
{
	static system_builder _instance;
	return &_instance;
}

main_loop* system_builder::initialize_system()
{
	win32_driver::instance();
	dxlib_driver::instance();
	image_lookup* il = image_lookup::instance();

	// --------------------------------------------------

	sequence* sa[ sequence_manager::sizeof_sequence_t ];

	static battle_sequence battle_sequence_;
	battle_sequence_.initialize_battle();
	sa[ sequence_manager::battle ] = &battle_sequence_;

	// --------------------------------------------------

	controller* ca[ sequence_manager::sizeof_sequence_t ];

	static battle_controller battle_controller_( &battle_sequence_ );
	ca[ sequence_manager::battle ] = &battle_controller_;

	// --------------------------------------------------

	static input_handler_dxlib input_handler_dxlib_;
	static main_loop main_loop_( sequence_manager::instance( sa, ca ), &input_handler_dxlib_ );

	return &main_loop_;
}

void system_builder::finalize_system()
{
	dxlib_driver* dd = dxlib_driver::instance();
	dd->dispose();

	win32_driver* wd = win32_driver::instance();
	wd->dispose();
}

system_builder::system_builder()
{
}

system_builder::~system_builder()
{
}
