/*
 * OpenI2CRADIO
 * Menu sub-routines / USER BAND.
 * Copyright (C) 2013-09-11 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "menu_memoryfreq.h"
#include "power.h"
#include "commondef.h"
#include "backlight.h"
#include "eeprom_util.h"

void call_userband(unsigned char num)
{
    unsigned int freq;
    unsigned int ch;
    unsigned char start;
    unsigned char end;
    unsigned char mode3k;
    unsigned int q;
    _userband_t *p;

    if(num >= USER_BAND_NUM) return;

    if(setup.fm != 0){
        p = &(userband.fm_usrbands[num]);
        freq = p->freq;
        mode3k = 0;
        ch = ((freq - 3000) / 5) * 2;
        setup.fmband = AKC6955_BAND_FMUSER;
        setup.fmfreq = freq;
    } else {
        p = &(userband.am_usrbands[num]);
        freq = p->freq;
        mode3k = p->mode3k;
        q = 5;
        if(mode3k != 0) q = 3;
        ch = freq / q;
        setup.amband = AKC6955_BAND_AMUSER;
        setup.amfreq = freq;
        setup.am_mode3k = mode3k;
    }
    start = p->start;
    end = p->stop;


    akc6955_set_userband(start, end, ch, mode3k);
}

void set_userband(void)
{
    unsigned long from,to;
    unsigned char c;
    unsigned char pp;
    unsigned char mode3k;
    unsigned int freq;
    unsigned int _from, _to, tmp;
    unsigned char cc;
    unsigned char fm = setup.fm;

    _CLS();
//    _LOCATE(0,0);
    c = 0;
    printstr("User ch:");
    c = pollkey_numeric(c);
    if(c >= USER_BAND_NUM) goto _l0;

    if(fm != 0){
        from = userband.fm_usrbands[c].start * 80 + 3000; // 32*25/10
        to = userband.fm_usrbands[c].stop * 80 + 3000;
        _CLS();
   //     _LOCATE(0,0);
        printstr("FM#");
        print_numeric_nosupress(c, 1);
    } else {
        mode3k = userband.am_usrbands[c].mode3k;
        pp = 96; // 3*32
        if(mode3k == 0) pp = 160; // 5*32
        from = userband.am_usrbands[c].start * pp;
        to = userband.am_usrbands[c].stop * pp;
        _CLS();
//        _LOCATE(0,0);
        printstr("AM#");
        print_numeric_nosupress(c, 1);
        printstr(" Step:");
        if(mode3k == 0){
            printstr("5K->");
        } else {
            printstr("3K->");
        }
        _LOCATE_0_1();
        printstr("0=3k 1=5k");
        cc = pollkey_single();
        if(cc == charcode_0){
            pp = 96;
            mode3k = 0xff;
        } else if(cc == charcode_1) {
            pp = 160;
            mode3k = 0;
        } else {
            goto _l0;
        }
        _LOCATE(10,0);
        if(mode3k == 0){
            printstr("5K  ");
        } else {
            printstr("3K  ");
        }
    }

    _LOCATE_0_1();
    printstr("From:");
    from = read_numeric(from, 5, 7, 1);
    if((from & 0xffff0000) != 0) goto _l0;
    _LOCATE_0_1();
    printstr("To:  ");
    to = read_numeric(to, 5, 7, 1);
    if((to & 0xffff0000) != 0) goto _l0;

    _from = (unsigned int)from;
    _to = (unsigned int)to;
    if(_from > _to){
         tmp = _to;
         _to = _from;
         _from = tmp;
    }
    freq = (_to - _from) / 2 + _from;

    _CLS();
    if(fm != 0){
        printstr("FM");
    } else {
        printstr("AM");
    }
    _PUTCHAR('#');
    _PUTCHAR('0' + c);
    printstr(" A=OK");
    _LOCATE_0_1();
    print_numeric_nosupress(_from, 5);
    printstr("->");
    print_numeric_nosupress(_to, 5);
    cc = pollkey_single();
    if(cc != charcode_a) goto _l0;
    if(fm != 0)
    {
        if((_from <= 3000) || (_from >= 28000)) goto _l0;
        if((_to <= 3000) || (_to >= 28000)) goto _l0;
        userband.fm_usrbands[c].start = (_from - 3000) / 80;
        userband.fm_usrbands[c].stop = (_to - 3000) / 80 + 1;
        userband.fm_usrbands[c].freq = freq;
        userband.fm_usrbands[c].mode3k = 0;
        setup.fm_userbandnum = c;
    } else {
        if((_from <100) || (_from >= 28000)) goto _l0;
        if((_to < 100) || (_to >= 28000)) goto _l0;
        userband.am_usrbands[c].start = _from / pp;
        userband.am_usrbands[c].stop = _to  / pp + 1;
        userband.am_usrbands[c].mode3k = mode3k;
        userband.am_usrbands[c].freq = freq;
        setup.am_userbandnum = c;
    }
    save_userbands();
    call_userband(c);
_l0:
    _CLS();
}

void input_userband(void)
{
    unsigned char c;
    int d;
        c = printhelp_2lines("User Band", "   #");
        if((c > charcode_a) && (c <= charcode_f)){
            goto _l0;
         }
        if(c == charcode_a){
            d = load_userbands();
            if(d < 0) format_userbands();

        } else {
            if(c == charcode_0) {
	       c = 0;
	    }
            _PUTCHAR('0' + c);
            if(setup.fm != 0){
                setup.fm_userbandnum = c;
            } else {
                setup.am_userbandnum = c;
            }
            call_userband(c);
        }
_l0:
    _CLS();
}

void list_userband(void)
{
    unsigned char i;
    unsigned char q;
    unsigned char c;

    for(i = 0; i < USER_BAND_NUM; i ++){
        _CLS();
        printstr("FM#");
        _PUTCHAR('0' + i);
        _LOCATE_0_1();
        print_numeric_nosupress(userband.fm_usrbands[i].start * 80 + 3000, 5);
        printstr(" to ");
        print_numeric_nosupress(userband.fm_usrbands[i].stop * 80 + 3000, 5);
        c = pollkey_single();
        if(c == charcode_a) {
            return;
        }
    }
    for(i = 0; i < USER_BAND_NUM; i ++){
        _CLS();
        printstr("AM#");
        _PUTCHAR('0' + i);
        _LOCATE_0_1();
        if(userband.am_usrbands[i].mode3k != 0){
            q = 3 * 32;
        } else {
            q = 5 * 32;
        }
        print_numeric_nosupress(userband.am_usrbands[i].start * q, 5);
        printstr(" to ");
        print_numeric_nosupress(userband.am_usrbands[i].stop *  q, 5);
        c = pollkey_single();
        if(c == charcode_a) {
            return;
        }
    }
}