/*
 * OpenI2CRADIO
 * Idle routine.
 * Using timer0.
 * Copyright (C) 2013-06-11 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <signal.h>
#include "iodef.h"


void idle_init(void)
{
   INTCON = INTCON & ~(_TMR0IF | _INT0IF | _RBIF); // Enable tmr0 as interrupt and clear interrupt flags.
   INTCON2 = ~_TMR0IP & _TMR0IP; // Interrupt is lower.

   WDTCON = 1; // OK? WDT=Disabled.
}


void stop_idle(void)
{
    T0CONbits.TMR0ON = 0;
}


void idle(unsigned int initial)
{
   unsigned char osccon;
   unsigned char  contword;

   /* Enable IDLE */
   osccon = OSCCON;
//   osccon = osccon | _IDLEN |  _SCS1 | _SCS0;
   osccon = osccon | _IDLEN & 0b11111100;
   OSCCON = osccon;
   INTCON |= _TMR0IE; // Enable tmr0 as interrupt and clear interrupt flags.
   
   /* Set TMR0 for interrupt*/
   /* Pre-scaler: 1/16, PSA=0(ON), TOSE=0, T0CS=0(INTERNAL), T08BIT=0(16bit), TMR0ON=1(START) */
   contword = _T0PS0 | _T0PS1 |  _TMR0ON; // _T0PS2
//   TMR0H = initial >> 8;
   TMR0H = initial >> 8;
   TMR0L = initial & 0xff;
   T0CON = contword;
   
   Sleep();
}
