/*
 * OpenI2CRADIO
 * UI Handler(Header)
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */


#ifndef UI_H
#define	UI_H

#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#endif

#include "lcd_acm1602.h"
#include "iodef.h"

#ifdef	__cplusplus
extern "C" {
#endif


extern keyin_defs keyin_old[2];
extern keyin_defs keyin_now;
extern char keyin_fifo[32];
extern char keyin_nowp;
extern char keyin_counter;

/*
 * LCD Primitives
 */
extern void _PUTCHAR(unsigned char c);
extern void _LOCATE(unsigned char x, unsigned char y);
extern void _LOCATE_0_0(void);
extern void _LOCATE_0_1(void);
extern void _CLS(void);
extern void _HOME(void);
extern void _CURSOR_ON(void);
extern void _CURSOR_OFF(void);
extern void _CURSOR_LEFT(void);
extern void _CURSOR_RIGHT(void);


extern void keyin_init(void);
#ifdef __SDCC
extern void push_keyinfifo(char b) __critical;
extern char pop_keyinfifo(void) __critical;
#else
extern void push_keyinfifo(char b);
extern char pop_keyinfifo(void);
#endif
extern unsigned char readkey_compare(void);

extern void printstr(const char *s);
extern void print_numeric(int i, unsigned char supressf);
extern void setsignal_tune(unsigned char flag);
extern void set_backlight(unsigned char flag, unsigned int val);
extern unsigned long read_numeric(unsigned int initial, unsigned char digit,
        char startx, char starty);
extern unsigned long subst_numeric(unsigned long start, unsigned char pos, unsigned char c);
extern void print_numeric_nosupress(unsigned long data, unsigned char digit);
extern unsigned char readkey(void);
extern unsigned char pollkey_single(void);
extern unsigned char pollkey_single_timeout(unsigned char limit, unsigned char repeat);
extern unsigned char pollkey_numeric(unsigned char init);

#ifdef	__cplusplus
}
#endif

#endif	/* UI_H */

