##
#	$Id: player.rb 10 2008-10-08 19:26:42Z yatsuhashi $
#
module GtkUI
  class Player < Gtk::Frame
    MARGIN	= 4
    WIDTH	= Hai.width * 20
    HEIGHT	= Hai.height * 2 + MARGIN * 3

    #
    def initialize
      super('player')
      vbox = Gtk::VBox.new

      @info = Gtk::Label.new
      @info.set_xalign(0)
      @point = 0
      show_info
      vbox.pack_start(@info, false)

      @hand = nil
      @taku = Taku.new(WIDTH, HEIGHT)
      @taku.events |= Gdk::Event::BUTTON_PRESS_MASK
      @taku.signal_connect('button-press-event') { |widget, event|
        if @hand and index = get_index(event.x, event.y)
          hai = @hand[index]
          MainWindow.instance.click_hai(hai, index == @hand.size - 1)
        end
      }
      vbox.pack_start(@taku, false)
      add(vbox)
    end
    attr_reader :hand

    #
    def set_name(name)
      set_label(name)
    end

    #
    def set_point(point)
      @point = point
      show_info
    end

    # 手牌をセット
    def set_tehai(haipai)
      @hand = Mahjong::Hand.new(haipai)
      draw
    end

    #
    def tsumo(hai)
      @hand.tsumo(hai ? Mahjong::Hai[hai] : nil)
      draw
    end

    #
    def sutehai(hai)
      @hand.sutehai(Mahjong::Hai[hai])
      draw
    end

    #
    def open(hais, naki)
      mentsu = Mahjong::Mentsu.parse(hais)
      @hand << mentsu
      mentsu.each { |hai|
        if hai.equal?(naki)
          naki = nil
        else
          @hand.drop(hai)
        end
      }
      draw
    end

    private

    # 描画
    def draw
      @taku.clear
      @taku.set_cursor(MARGIN, MARGIN + Hai.height)
      kawa = @hand.kawa.dup
      while !kawa.empty?
        hais = kawa.slice!(0, 6)
        hais.each { |hai| @taku.draw_hai(Hai[hai]) }
        @taku.move_cursor(MARGIN)
      end

      @taku.set_cursor(MARGIN, (MARGIN + Hai.height) * 2)

      pixmap = Hai['back']
      @hand.fusehai.times { @taku.draw_hai(pixmap) }

      @hand.each_menzen { |hai|
        @taku.draw_hai(Hai[hai])
      }
      @taku.set_cursor(MARGIN + Hai.width * 18, (MARGIN + Hai.height) * 2)
      @hand.each_mentsu { |mentsu|
        mentsu.each { |hai| @taku.draw_hai(Hai[hai]) }
        @taku.move_cursor(MARGIN)
      }
      @taku.flush
    end

    #
    def get_index(x, y)
      x -= MARGIN
      y -= MARGIN * 2 + Hai.height
      if y >= 0 and y < Hai.height and x >= 0 and x < Hai.width * @hand.size
        (x / Hai.width).to_i
      end
    end

    #
    def show_info
      @info.set_text("点数 #{@point}")
    end
  end
end
