##
#	$Id: taku.rb 8 2008-10-06 17:54:27Z yatsuhashi $
#
module GtkUI
  class Taku < Gtk::DrawingArea
    COLOR = 0x00800080

    #
    def initialize(width, height)
      super()
      set_size_request(width, height)
      @pixbuf = Gdk::Pixbuf.new(Gdk::Pixbuf::COLORSPACE_RGB, false, 8, 
                                width, height)
      signal_connect('expose-event') { |widget, event|
        expose(widget, event)
      }
      signal_connect('size-allocate') { |widget, allocation|
        if allocation.width > @pixbuf.width or
            allocation.height > @pixbuf.height
          pixbuf = Gdk::Pixbuf.new(Gdk::Pixbuf::COLORSPACE_RGB, false, 8, 
                                   allocation.width, allocation.height)
          pixbuf.fill!(COLOR)
          @pixbuf.copy_area(0, 0, @pixbuf.width, @pixbuf.height, 
                            pixbuf, 0, 0)
          @pixbuf = pixbuf
        end
      }
      clear
      flush
    end

    #
    def clear
      @pixbuf.fill!(COLOR)
      set_cursor(0, Hai.height)
      self
    end

    #
    def set_cursor(x, y)
      @x = x
      @y = y
    end

    #
    def move_cursor(x, y = 0)
      @x += x
      @y += y
    end

    #
    def draw_hai(hai)
      y = @y - hai.height
      @pixbuf.composite!(hai, @x, y, hai.width, hai.height, @x, y, 1, 1, 
                         Gdk::Pixbuf::INTERP_NEAREST, 255)
      move_cursor(hai.width)
      self
    end

    #
    def flush
      queue_draw
    end

    #
    def expose(widget, event)
      pixbuf = Gdk::Pixbuf.new(@pixbuf, event.area.x, event.area.y, 
                               event.area.width, event.area.height)
      Gdk::RGB.draw_rgb_image(widget.window,
                              widget.style.black_gc, 
                              event.area.x, event.area.y,
                              event.area.width, event.area.height,
                              Gdk::RGB::Dither::NONE,
                              pixbuf.pixels, pixbuf.rowstride, 
                              event.area.x, event.area.y)
      true
    end
  end
end
