##
#	$Id: mainframe.rb 21 2008-11-16 18:27:54Z yatsuhashi $
#
module WxUI
  UMP_VERSION = '0.1'

  #
  class MainFrame < Wx::Frame
    PLAYER_MAX = 4

    BUTTONS = {
      :CHI	=> 'チー', 
      :PON	=> 'ポン', 
      :KAN	=> 'カン', 
      :RON	=> 'ロン', 
      :TSUMO	=> 'ツモ', 
      :RICHI	=> 'リーチ', 
      :OK	=> 'OK', 
      :PASS	=> 'パス', 
      :NOTEN	=> 'ノーテン', 
      :TENPAI	=> 'テンパイ', 
      :CONNECT	=> '接続', 
      :RUN_AI	=> 'AI起動'
    }

    MENU = [ [ 'ゲーム', 
               [ [ '接続', :connect ],  
                 [ '終了', :quit ] ] ] ]

    #
    def initialize
      super(nil, :title => 'OpenMj')

      @vbox = Wx::BoxSizer.new(Wx::VERTICAL)

      MenuBar.new(self, MENU)

      hbox = Wx::BoxSizer.new(Wx::HORIZONTAL)
      hbox.add(Wx::Button.new(self, :CONNECT.to_i, '接続'))
      hbox.add(Wx::Button.new(self, :RUN_AI.to_i, 'AI起動'))
      @vbox.add(hbox)

      @information = Information.new(self)
      @vbox.add(@information)

      @taku = Taku.new(self, self)
      @vbox.add(@taku)

      @buttons = Array.new
      hbox = Wx::BoxSizer.new(Wx::HORIZONTAL)
      5.times {
        button = Wx::Button.new(self, -1, '-')
        hbox.add(button, 1, Wx::EXPAND)
        @buttons << button
      }
      @vbox.add(hbox)

      #@console = Console.new(self)
      #@vbox.add(@console, 1, Wx::EXPAND)

      size = @taku.get_size
      size.set_height(-1)
      set_max_size(size)

      @vbox.fit(self)
      set_sizer(@vbox)

      @client = nil

      BUTTONS.each_key { |symbol|
        evt_button(symbol.to_i) { select_button(symbol) }
      }

      timer = Wx::Timer.new(self, 55)
      evt_timer(55) {
        if @client
          @client.notify_observers
        end
        Thread.pass
      }
      timer.start(100)
    end
    attr_reader :client, :mode

    #
    def start_game
      begin
        @client = OpenMj::Client.new
        @client.add_observer(@taku)
        Thread.start {
          @client.start { |command, args|
            #@console.puts("#{command} #{args.join(' ')}")
            @mode = nil
            @sutehai = nil
            case command
            when 'hello'
              @client.send('hello', "ump=#{UMP_VERSION}")
            when 'gamestart'
            when 'point'
            when 'kyokustart'
              @taku.reset
            when 'sutehai?'
              @mode = :SUTEHAI
              set_button(nil, nil, :KAN, :RICHI, :TSUMO)
            when 'naku?'
              @mode = :NAKI
              @sutehai = Mahjong::Hai[args.shift]
              naki(args)
            when 'tenpai?'
              set_button(nil, nil, nil, :NOTEN, :TENPAI)
            when 'ready?'
              set_button(nil, nil, nil, nil, :OK)
            when 'dora'
              @taku.append_dora(Mahjong::Hai[args[0]])
=begin
            when 'open'
              get_player(args[0]).open(args[1], args[2])
=end
            end
          }
        }
      rescue Errno::ECONNREFUSED
        @client = nil
      end
    end

    #
    def set_button(*buttons)
      @buttons.each_with_index { |button, i|
        symbol = buttons[i]
        button.set_id(symbol.to_i)
        button.set_label(symbol ? BUTTONS[symbol] : '-')
      }
    end

    #
    def quit
      close(true)
    end

    #
    def select_hai(hai, is_tsumogiri)
      case @mode
      when :SUTEHAI
        cmd = [ 'sutehai', hai.to_s ]
        if is_tsumogiri
          cmd << 'tsumogiri'
        end
        @client.send(cmd)
      end
    end

    #
    def pass
      case @mode
      when :NAKI
        @client.send('pass')
      end
    end

    #
    def select_button(symbol)
      case symbol
      when :CONNECT
        start_game
      when :RUN_AI
        Thread.start {
          Ai::Base.new('localhost', 1326).start
        }
      when :TSUMO
        @client.send('tsumo')
      when :RON
        @client.send('ron')
      when :PASS
        @client.send('pass')
      when :NOTEN
        @client.send('no')
      when :TENPAI
        @client.send('yes')
      when :OK
        @client.send('ok')
      end
    end

    #
    def naki(args)
      buttons = [ nil, nil, nil, :PASS, nil ]
      args.each { |arg|
        case arg
        when 'chi'
          buttons[0] = :CHI
        when 'pon'
          buttons[1] = :PON
        when 'kan'
          buttons[2] = :KAN
        when 'ron'
          buttons[4] = :RON
        end
      }
      set_button(*buttons)
    end
  end
end
