/***********************************************************************//**
	@file
	$Revision: 77 $
	$Author: yatsuhashi $
	$Date:: 2009-03-26 02:38:16 +0900#$
***************************************************************************/
#ifndef __LIBMAHJONG_AGARI_H__
#define __LIBMAHJONG_AGARI_H__

#include <vector>
#include <bitset>
#include "libmahjong/Mentsu.h"

namespace mahjong {
/***********************************************************************//**
	和了.
***************************************************************************/
class Agari {
  public:
    typedef std::vector<Agari> Vector;

    enum {
        YAKU_RICHI, 		/**< リーチ */
        YAKU_TANYAO, 		/**< タンヤオ */
        YAKU_PINFU, 		/**< 平和 */
        YAKU_TSUMO, 		/**< 門前自摸 */
        YAKU_IPEIKOU, 		/**< 一盃口 */
        YAKU_CHITOI, 		/**< 七対子 */
        YAKU_CHANTA, 		/**< チャンタ */
        YAKU_JUNCHAN, 		/**< 純チャン */
        YAKU_HONROUTOU, 	/**< 混老頭 */
        YAKU_TOITOI, 		/**< 対々和 */
        YAKU_SANANKO, 		/**< 三暗刻 */
        YAKU_SANKANTSU, 	/**< 三槓子 */
        YAKU_RYANPEIKOU, 	/**< 二盃口 */
        YAKU_SANSHOKU, 		/**< 三色同順 */
        YAKU_SANSHOKUDOUKOU, 	/**< 三色同刻 */
        YAKU_ITSU, 		/**< 一気通貫 */
        YAKU_YAKUHAI, 		/**< 役牌 */
        YAKU_SHOSANGEN, 	/**< 小三元 */
        YAKU_HONITSU, 		/**< 混一色 */
        YAKU_CHINITSU, 		/**< 清一色 */
        YAKUMAN, 		/**< 役満 */
        YAKUMAN_KOKUSHI, 	/**< 国士無双 */
        YAKUMAN_DAISANGEN, 	/**< 大三元 */
        YAKUMAN_CHINROUTOU, 	/**< 清老頭 */
        YAKUMAN_SUANKO, 	/**< 四暗刻 */
        YAKUMAN_SUKANTSU, 	/**< 四槓子 */
        YAKUMAN_SHOSUSHI, 	/**< 小四喜 */
        YAKUMAN_DAISUSHI, 	/**< 大四喜 */
        YAKUMAN_TSUISOU, 	/**< 字一色 */
        YAKUMAN_RYUISOU, 	/**< 緑一色 */
        YAKUMAN_CHUREN, 	/**< 九蓮宝燈 */
        YAKU_MAX
    };

  private:
    enum {
        FLAG_CALC, 
        FLAG_RON, 
        FLAG_NOT_MENZEN, 
        FLAG_YAKUMAN, 
        FLAG_MAX
    };

    struct YakuTable {
        int menzenHan;
        int nakiHan;
        const char* yakuName;
    };

  private:
    Mentsu::Vector mentsu_;
    unsigned char yaku_[YAKU_MAX];
    int han_;
    int fu_;
    std::bitset<FLAG_MAX> flag_;

    static const YakuTable yakuTable[YAKU_MAX];

  public:
    Agari();
    void clear();

    int getHan() const;
    int getHan(int yaku) const;
    int getFu() const;
    int getYakuman() const;
    bool isYakuman() const;
    bool isInclude(int yaku) const;

    void pushMentsu(const Mentsu& mentsu);
    void popMentsu();

    Agari setAgariHai(const Hai* hai, bool isRon);
    void appendYaku(int yaku);

    bool operator<(const Agari& other);

    std::string toString() const;

  private:
    bool isCalc() const;
    bool isMenzen() const;

    void checkYaku();
    void clearYaku();
};
/***********************************************************************//**
	$Id: Agari.h 77 2009-03-25 17:38:16Z yatsuhashi $
***************************************************************************/
}	/* namespace mahjong */
#endif	/* __LIBMAHJONG_AGARI_H__ */
