/***********************************************************************//**
	@file
	$Revision: 73 $
	$Author: yatsuhashi $
	$Date:: 2009-03-20 03:07:24 +0900#$
***************************************************************************/
#include "libmahjong/Sutehai.h"

namespace mahjong {
/***********************************************************************//**
	コンストラクタ.
	@param	hai	牌
***************************************************************************/
Sutehai::Sutehai(const Hai* hai)
    : hai_(hai)
{}
/***********************************************************************//**
	@return	牌
***************************************************************************/
const Hai* Sutehai::getHai() const {
    return hai_;
}
/***********************************************************************//**
	@return	ツモ切りのとき真
***************************************************************************/
bool Sutehai::isTsumogiri() const {
    return flag_.test(FLAG_TSUMOGIRI);
}
/***********************************************************************//**
	@return	鳴かれているとき真
***************************************************************************/
bool Sutehai::isNaki() const {
    return flag_.test(FLAG_NAKI);
}
/***********************************************************************//**
	@return	リーチのとき真
***************************************************************************/
bool Sutehai::isRichi() const {
    return flag_.test(FLAG_RICHI);
}
/***********************************************************************//**
	ツモ切りフラグをセットする
***************************************************************************/
void Sutehai::setTsumogiri() {
    flag_.set(FLAG_TSUMOGIRI);
}
/***********************************************************************//**
	鳴かれフラグをセットする
***************************************************************************/
void Sutehai::setNaki() {
    flag_.set(FLAG_NAKI);
}
/***********************************************************************//**
	リーチフラグをセットする
***************************************************************************/
void Sutehai::setRichi() {
    flag_.set(FLAG_RICHI);
}
/***********************************************************************//**
	$Id: Sutehai.cpp 73 2009-03-19 18:07:24Z yatsuhashi $
***************************************************************************/
}	/* namespace mahjong */
