/***********************************************************************//**
	@file
	$Revision$
	$Author$
	$Date::                           $
***************************************************************************/
#ifndef __OPENMJ_CLIENT_CLIENT_H__
#define __OPENMJ_CLIENT_CLIENT_H__

#include <queue>
#include <string>
#include <vector>
#include "libmahjong.h"
#include "common/Socket.h"
#include "common/Player.h"
#include "common/Version.h"

namespace openmj {
class Command;
namespace client {
/***********************************************************************//**
	クライアント.
***************************************************************************/
class Client {
  public:
    static const Version UMP_VERSION;

  protected:
    typedef std::vector<Player> PlayerList;

  private:
    Socket socket_;
    PlayerList playerList;
    char seki;
    int restYama;
    mahjong::Sutehai* lastSutehai;
    const mahjong::Hai* bakaze_;
    int oya_;
    int tsumibou_;
    int kyotaku_;

  public:
    Client();
    ~Client();

    bool connect(const char* host, int port);
    bool isConnect() const;

    void exec();

    void send(const Command& command);

    Player* getPlayer(const std::string& seki);
    Player* getPlayer();
    std::vector<const Player*> getPlayers();

    int getOya() const;
    int getTsumibou() const;
    int getKyotaku() const;
    const mahjong::Hai* getBakaze() const;
    const mahjong::Sutehai* getLastSutehai() const;

    void replyCommand(const Command& command);

    void dump();
    virtual void log(const char* message) {}

  protected:
    virtual void recvCommand(const Command& command);

  private:
    void recv(const Command& command);
    void execGameStart(const Command& command);
    void execKyokuStart(const Command& command);
    void execHaipai(const Command& command);
    void execPoint(const Command& command);
    void execTsumo(const Command& command);
    void execSutehai(const Command& command);
    void execOpen(const Command& command);
    void execSay(const Command& command);
    void execAgari(const Command& command);
    void execRyukyoku(const Command& command);

    void replyHello(const Command& command);
    void replyReady(const Command& command);
    void replyTenpai(const Command& command);
    void replyNaku(const Command& command);
    void replySutehai(const Command& command);
};
/***********************************************************************//**
	$Id$
***************************************************************************/
}	/* namespace client */
}	/* namespace openmj */
#endif	/* __OPENMJ_CLIENT_CLIENT_H__ */
