/***********************************************************************//**
	@file
	$Revision: 82 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:46:44 +0900#$
***************************************************************************/
#include "DrawQueue.h"
#include "DrawPacket.h"

namespace openmj {
namespace gui {
/***********************************************************************//**
	コンストラクタ
***************************************************************************/
DrawQueue::DrawQueue()
    : top_(0)
{}
/***********************************************************************//**
	デストラクタ
***************************************************************************/
DrawQueue::~DrawQueue() {
    DrawPacket* packet = top_;
    while(packet) {
        DrawPacket* nextPacket = packet->getNext();
        delete packet;
        packet = nextPacket;
    }
}
/***********************************************************************//**
	パケットを追加する
***************************************************************************/
void DrawQueue::appendPacket(DrawPacket* packet) {
    if(top_) {
        DrawPacket* prev = 0;
        DrawPacket* iter = top_;
        while(iter && *iter < *packet) {
            prev = iter;
            iter = iter->getNext();
        }
        if(iter) {
            packet->setNext(iter);
        }
        if(prev) {
            prev->setNext(packet);
        }
        else {
            top_ = packet;
        }
    }
    else {
        top_ = packet;
    }
}
/***********************************************************************//**
	描画.
***************************************************************************/
void DrawQueue::flush(wxDC& dc) {
    DrawPacket* packet = top_;
    while(packet) {
        packet->draw(dc);
        DrawPacket* nextPacket = packet->getNext();
        delete packet;
        packet = nextPacket;
    }
    top_ = 0;
}
/***********************************************************************//**
	$Id: DrawQueue.cpp 82 2009-03-28 13:46:44Z yatsuhashi $
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
