/***********************************************************************//**
	@file
	$Revision: 80 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:08:47 +0900#$
***************************************************************************/
#include <sstream>
#include "common/Socket.h"
#include "common/Command.h"
#include "Lobby.h"
#include "Game.h"
#include "Player.h"

namespace openmj {
namespace server {

const Version Lobby::UMP_VERSION(0, 1);
/***********************************************************************//**
	コンストラクタ
***************************************************************************/
Lobby::Lobby()
    : game_(0)
{
    socket_.listen(1326);
}
/***********************************************************************//**
	デストラクタ
***************************************************************************/
Lobby::~Lobby() {
    delete game_;
}
/***********************************************************************//**
	実行
***************************************************************************/
void Lobby::exec() {
    newGame();
    while(true) {
        Socket* socket = socket_.accept();
        if(socket) {
            Player* player = new Player(socket);
            std::ostringstream hello;
            hello << "hello ump=" << UMP_VERSION.toString();
            player->send(hello.str().c_str());
            player->recv(this);
        }
    }
}
/***********************************************************************//**
	新しいゲーム
***************************************************************************/
void Lobby::newGame() {
    if(game_) {
        game_->start();
    }
    game_ = new Game(1);
}
/***********************************************************************//**
	メッセージ受信
***************************************************************************/
void Lobby::recv(Player* player, const Command& command) {
    boost::mutex::scoped_lock mutex(mutex_);
    if(command.getCommand() == Command::CMD_HELLO) {
        if(game_->appendPlayer(player)) {
            newGame();
        }
    }
}
/***********************************************************************//**
	$Id: Lobby.cpp 80 2009-03-28 13:08:47Z yatsuhashi $
***************************************************************************/
}	/* namespace server */
}	/* namespace openmj */
